/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Throwables;
import io.druid.segment.QueryableIndex;
import io.druid.segment.ReferenceCountingSegment;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Before;
import org.junit.Test;

public class ReferenceCountingSegmentTest {
    private ReferenceCountingSegment segment;
    private ExecutorService exec;

    @Before
    public void setUp() throws Exception {
        this.segment = new ReferenceCountingSegment(new Segment(){

            public String getIdentifier() {
                return "test_segment";
            }

            public Interval getDataInterval() {
                return new Interval((ReadableInstant)DateTime.now().minus((ReadablePeriod)Days.days((int)1)), (ReadableInstant)DateTime.now());
            }

            public QueryableIndex asQueryableIndex() {
                return null;
            }

            public StorageAdapter asStorageAdapter() {
                return null;
            }

            public void close() throws IOException {
            }
        });
        this.exec = Executors.newSingleThreadExecutor();
    }

    @Test
    public void testMultipleClose() throws Exception {
        Assert.assertFalse((boolean)this.segment.isClosed());
        final Closeable closeable = this.segment.increment();
        Assert.assertTrue((this.segment.getNumReferences() == 1 ? 1 : 0) != 0);
        closeable.close();
        closeable.close();
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        Assert.assertTrue((this.segment.getNumReferences() == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.segment.isClosed());
        this.segment.close();
        this.segment.close();
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReferenceCountingSegmentTest.this.segment.close();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        Assert.assertTrue((this.segment.getNumReferences() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.segment.isClosed());
        this.segment.increment();
        this.segment.increment();
        this.segment.increment();
        Assert.assertTrue((this.segment.getNumReferences() == 0 ? 1 : 0) != 0);
        this.segment.close();
        Assert.assertTrue((this.segment.getNumReferences() == 0 ? 1 : 0) != 0);
    }
}

