/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexSpec;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.junit.Assert;
import org.junit.Test;

public class IndexSpecTest {
    @Test
    public void testConfiguredBitmap() throws Exception {
        Assert.assertEquals((Object)new ConciseBitmapSerdeFactory(), (Object)IndexIO.CONFIGURED_BITMAP_SERDE_FACTORY);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"bitmap\" : { \"type\" : \"roaring\" }, \"dimensionCompression\" : \"lz4\", \"metricCompression\" : \"lzf\" }";
        IndexSpec spec = (IndexSpec)objectMapper.readValue("{ \"bitmap\" : { \"type\" : \"roaring\" }, \"dimensionCompression\" : \"lz4\", \"metricCompression\" : \"lzf\" }", IndexSpec.class);
        Assert.assertEquals((Object)new RoaringBitmapSerdeFactory(), (Object)spec.getBitmapSerdeFactory());
        Assert.assertEquals((Object)CompressedObjectStrategy.CompressionStrategy.LZ4, (Object)spec.getDimensionCompressionStrategy());
        Assert.assertEquals((Object)CompressedObjectStrategy.CompressionStrategy.LZF, (Object)spec.getMetricCompressionStrategy());
        Assert.assertEquals((Object)spec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)spec), IndexSpec.class));
    }

    @Test
    public void testSerdeUncompressed() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"dimensionCompression\" : \"uncompressed\" }";
        IndexSpec spec = (IndexSpec)objectMapper.readValue("{ \"dimensionCompression\" : \"uncompressed\" }", IndexSpec.class);
        Assert.assertEquals((Object)"uncompressed", (Object)spec.getDimensionCompression());
        Assert.assertEquals(null, (Object)spec.getDimensionCompressionStrategy());
        Assert.assertEquals((Object)spec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)spec), IndexSpec.class));
    }

    @Test
    public void testDefaults() throws Exception {
        IndexSpec spec = new IndexSpec();
        Assert.assertEquals((Object)IndexIO.CONFIGURED_BITMAP_SERDE_FACTORY, (Object)spec.getBitmapSerdeFactory());
        Assert.assertEquals((Object)CompressedObjectStrategy.CompressionStrategy.LZ4, (Object)spec.getDimensionCompressionStrategy());
        Assert.assertEquals((Object)CompressedObjectStrategy.CompressionStrategy.LZ4, (Object)spec.getMetricCompressionStrategy());
    }
}

