/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.segment.CloserRule;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.SimpleDictionaryEncodedColumn;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.IncrementalIndexTest;
import io.druid.segment.data.RoaringBitmapSerdeFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexMergerTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final IndexSpec indexSpec;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    @Parameterized.Parameters(name="{index}: bitmap={0}, metric compression={1}, dimension compression={2}")
    public static Collection<Object[]> data() {
        return Collections2.transform((Collection)Sets.cartesianProduct((List)ImmutableList.of((Object)ImmutableSet.of((Object)new RoaringBitmapSerdeFactory(), (Object)new ConciseBitmapSerdeFactory()), (Object)ImmutableSet.of((Object)CompressedObjectStrategy.CompressionStrategy.LZ4, (Object)CompressedObjectStrategy.CompressionStrategy.LZF), (Object)ImmutableSet.of((Object)CompressedObjectStrategy.CompressionStrategy.LZ4, (Object)CompressedObjectStrategy.CompressionStrategy.LZF))), (Function)new Function<List<?>, Object[]>(){

            @Nullable
            public Object[] apply(List<?> input) {
                return input.toArray();
            }
        });
    }

    static IndexSpec makeIndexSpec(BitmapSerdeFactory bitmapSerdeFactory, CompressedObjectStrategy.CompressionStrategy compressionStrategy, CompressedObjectStrategy.CompressionStrategy dimCompressionStrategy) {
        if (bitmapSerdeFactory != null || compressionStrategy != null) {
            return new IndexSpec(bitmapSerdeFactory, compressionStrategy.name().toLowerCase(), dimCompressionStrategy.name().toLowerCase());
        }
        return new IndexSpec();
    }

    public IndexMergerTest(BitmapSerdeFactory bitmapSerdeFactory, CompressedObjectStrategy.CompressionStrategy compressionStrategy, CompressedObjectStrategy.CompressionStrategy dimCompressionStrategy) {
        this.indexSpec = IndexMergerTest.makeIndexSpec(bitmapSerdeFactory, compressionStrategy, dimCompressionStrategy);
    }

    @Test
    public void testPersist() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist, (File)tempDir, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)2L, (long)index.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testPersistMerge() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        OnheapIncrementalIndex toPersist2 = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[]{new CountAggregatorFactory("count")}, 1000);
        toPersist2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2")));
        toPersist2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"5", (Object)"dim2", (Object)"6")));
        File tempDir1 = this.temporaryFolder.newFolder();
        File tempDir2 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tempDir1, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)2L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        QueryableIndex index2 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist2, (File)tempDir2, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)2L, (long)index2.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index2.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index2.getColumnNames().size());
        QueryableIndex merged = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), (AggregatorFactory[])new AggregatorFactory[]{new CountAggregatorFactory("count")}, (File)mergedDir, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)3L, (long)merged.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        this.assertDimCompression(index2, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testPersistEmptyColumn() throws Exception {
        OnheapIncrementalIndex toPersist1 = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[0], 10);
        OnheapIncrementalIndex toPersist2 = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[0], 10);
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        toPersist1.add((InputRow)new MapBasedInputRow(1L, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)ImmutableList.of(), (Object)"dim2", (Object)"foo")));
        toPersist2.add((InputRow)new MapBasedInputRow(1L, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)ImmutableList.of(), (Object)"dim2", (Object)"bar")));
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tmpDir1, (IndexSpec)this.indexSpec)));
        QueryableIndex index2 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tmpDir2, (IndexSpec)this.indexSpec)));
        QueryableIndex merged = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), (AggregatorFactory[])new AggregatorFactory[0], (File)tmpDir3, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)1L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)1L, (long)index2.getColumn("__time").getLength());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)index2.getAvailableDimensions()));
        Assert.assertEquals((long)1L, (long)merged.getColumn("__time").getLength());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)merged.getAvailableDimensions()));
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(index2, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testMergeRetainsValues() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tempDir1, (IndexSpec)this.indexSpec)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        QueryableIndex merged = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex((List)ImmutableList.of((Object)index1), (AggregatorFactory[])new AggregatorFactory[]{new CountAggregatorFactory("count")}, (File)mergedDir, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)2L, (long)merged.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)tempDir1, (File)mergedDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testAppendRetainsValues() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.append((List)ImmutableList.of((Object)incrementalAdapter), (File)tempDir1, (IndexSpec)this.indexSpec)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        QueryableIndex merged = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex((List)ImmutableList.of((Object)index1), (AggregatorFactory[])new AggregatorFactory[]{new CountAggregatorFactory("count")}, (File)mergedDir, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)2L, (long)merged.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)tempDir1, (File)mergedDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testMergeSpecChange() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tempDir1, (IndexSpec)this.indexSpec)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        IndexSpec newSpec = new IndexSpec(this.indexSpec.getBitmapSerdeFactory(), "lz4".equals(this.indexSpec.getDimensionCompression()) ? "lzf" : "lz4", "lz4".equals(this.indexSpec.getMetricCompression()) ? "lzf" : "lz4");
        QueryableIndex merged = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex((List)ImmutableList.of((Object)index1), (AggregatorFactory[])new AggregatorFactory[]{new CountAggregatorFactory("count")}, (File)mergedDir, (IndexSpec)newSpec)));
        Assert.assertEquals((long)2L, (long)merged.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)tempDir1, (File)mergedDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(merged, newSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testConvertSame() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, new AggregatorFactory[]{new LongSumAggregatorFactory("longSum1", "dim1"), new LongSumAggregatorFactory("longSum2", "dim2")});
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File convertDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tempDir1, (IndexSpec)this.indexSpec)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)4L, (long)index1.getColumnNames().size());
        QueryableIndex converted = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.convert((File)tempDir1, (File)convertDir, (IndexSpec)this.indexSpec)));
        Assert.assertEquals((long)2L, (long)converted.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)converted.getAvailableDimensions()));
        Assert.assertEquals((long)4L, (long)converted.getColumnNames().size());
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)tempDir1, (File)convertDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(converted, this.indexSpec.getDimensionCompressionStrategy());
    }

    @Test
    public void testConvertDifferent() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(true, new AggregatorFactory[]{new LongSumAggregatorFactory("longSum1", "dim1"), new LongSumAggregatorFactory("longSum2", "dim2")});
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File convertDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.persist((IncrementalIndex)toPersist1, (File)tempDir1, (IndexSpec)this.indexSpec)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)4L, (long)index1.getColumnNames().size());
        IndexSpec newSpec = new IndexSpec(this.indexSpec.getBitmapSerdeFactory(), "lz4".equals(this.indexSpec.getDimensionCompression()) ? "lzf" : "lz4", "lz4".equals(this.indexSpec.getMetricCompression()) ? "lzf" : "lz4");
        QueryableIndex converted = this.closer.closeLater(IndexIO.loadIndex((File)IndexMerger.convert((File)tempDir1, (File)convertDir, (IndexSpec)newSpec)));
        Assert.assertEquals((long)2L, (long)converted.getColumn("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)converted.getAvailableDimensions()));
        Assert.assertEquals((long)4L, (long)converted.getColumnNames().size());
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)tempDir1, (File)convertDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompressionStrategy());
        this.assertDimCompression(converted, newSpec.getDimensionCompressionStrategy());
    }

    private void assertDimCompression(QueryableIndex index, CompressedObjectStrategy.CompressionStrategy expectedStrategy) throws Exception {
        DictionaryEncodedColumn encodedColumn = index.getColumn("dim2").getDictionaryEncoding();
        Field field = SimpleDictionaryEncodedColumn.class.getDeclaredField("column");
        field.setAccessible(true);
        Object obj = field.get(encodedColumn);
        Field compressedSupplierField = obj.getClass().getDeclaredField("this$0");
        compressedSupplierField.setAccessible(true);
        Object supplier = compressedSupplierField.get(obj);
        Field compressionField = supplier.getClass().getDeclaredField("compression");
        compressionField.setAccessible(true);
        Object strategy = compressionField.get(supplier);
        Assert.assertEquals((Object)expectedStrategy, (Object)strategy);
    }
}

