/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.segment.CloserRule;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMaker;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexMergerTest;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexMakerTest {
    @Rule
    public final CloserRule closer = new CloserRule(false);
    private static final long TIMESTAMP = DateTime.parse((String)"2014-01-01").getMillis();
    private static final AggregatorFactory[] DEFAULT_AGG_FACTORIES = new AggregatorFactory[]{new CountAggregatorFactory("count")};
    private static final IndexSpec INDEX_SPEC = IndexMergerTest.makeIndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressedObjectStrategy.CompressionStrategy.LZ4, CompressedObjectStrategy.CompressionStrategy.LZ4);
    private static final List<String> DIMS = ImmutableList.of((Object)"dim0", (Object)"dim1");
    private static final Function<Collection<Map<String, Object>>, Object[]> OBJECT_MAKER = new Function<Collection<Map<String, Object>>, Object[]>(){

        @Nullable
        public Object[] apply(Collection<Map<String, Object>> input) {
            ArrayList<MapBasedInputRow> list = new ArrayList<MapBasedInputRow>();
            int i = 0;
            for (Map<String, Object> map : input) {
                list.add(new MapBasedInputRow(TIMESTAMP + (long)i++, DIMS, map));
            }
            return new Object[]{list};
        }
    };
    private final Collection<InputRow> events;
    IncrementalIndex toPersist;
    File tmpDir;
    File persistTmpDir;

    @SafeVarargs
    public static Collection<Object[]> permute(Map<String, Object> ... maps) {
        if (maps == null) {
            return ImmutableList.of();
        }
        return Collections2.transform((Collection)Collections2.permutations(Arrays.asList(maps)), OBJECT_MAKER);
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> paramFeeder() {
        ImmutableMap map1 = ImmutableMap.of((Object)DIMS.get(0), (Object)ImmutableList.of((Object)"dim00", (Object)"dim01"), (Object)DIMS.get(1), (Object)"dim10");
        List<Object> nullList = Collections.singletonList(null);
        ImmutableMap map2 = ImmutableMap.of((Object)DIMS.get(0), nullList, (Object)DIMS.get(1), (Object)"dim10");
        ImmutableMap map3 = ImmutableMap.of((Object)DIMS.get(0), (Object)ImmutableList.of((Object)"dim00", (Object)"dim01"));
        ImmutableMap map4 = ImmutableMap.of();
        ImmutableMap map5 = ImmutableMap.of((Object)DIMS.get(1), (Object)"dim10");
        HashMap<String, Object> map6 = new HashMap<String, Object>();
        map6.put(DIMS.get(1), null);
        return Iterables.concat((Iterable[])new Iterable[]{IndexMakerTest.permute(new Map[]{map1}), IndexMakerTest.permute(new Map[]{map1, map4}), IndexMakerTest.permute(new Map[]{map1, map5}), IndexMakerTest.permute(new Map[]{map5, map6}), IndexMakerTest.permute(new Map[]{map4, map5}), Iterables.transform((Iterable)ImmutableList.of(Arrays.asList(map1, map2, map3, map4, map5, map6)), OBJECT_MAKER)});
    }

    public IndexMakerTest(Collection<InputRow> events) {
        this.events = events;
    }

    @Before
    public void setUp() throws IOException {
        this.toPersist = new OnheapIncrementalIndex(-4611686018427387904L, QueryGranularity.NONE, DEFAULT_AGG_FACTORIES, 1000000);
        for (InputRow event : this.events) {
            this.toPersist.add(event);
        }
        this.tmpDir = Files.createTempDir();
        this.persistTmpDir = new File(this.tmpDir, "persistDir");
        IndexMerger.persist((IncrementalIndex)this.toPersist, (File)this.persistTmpDir, (IndexSpec)INDEX_SPEC);
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void testSimpleReprocess() throws IOException {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)this.persistTmpDir)));
        Assert.assertEquals((long)this.events.size(), (long)adapter.getNumRows());
        this.reprocessAndValidate(this.persistTmpDir, new File(this.tmpDir, "reprocessed"));
    }

    private File reprocessAndValidate(File inDir, File tmpDir) throws IOException {
        File outDir = IndexMaker.convert((File)inDir, (File)tmpDir, (IndexSpec)INDEX_SPEC);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)this.persistTmpDir, (File)outDir);
        return outDir;
    }

    private File appendAndValidate(File inDir, File tmpDir) throws IOException {
        File outDir = IndexMerger.append((List)ImmutableList.of((Object)new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)inDir)))), (File)tmpDir, (IndexSpec)INDEX_SPEC);
        IndexIO.DefaultIndexIOHandler.validateTwoSegments((File)this.persistTmpDir, (File)outDir);
        return outDir;
    }

    @Test
    public void testIdempotentReprocess() throws IOException {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)this.persistTmpDir)));
        Assert.assertEquals((long)this.events.size(), (long)adapter.getNumRows());
        File tmpDir1 = new File(this.tmpDir, "reprocessed1");
        this.reprocessAndValidate(this.persistTmpDir, tmpDir1);
        File tmpDir2 = new File(this.tmpDir, "reprocessed2");
        QueryableIndexIndexableAdapter adapter2 = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)tmpDir1)));
        Assert.assertEquals((long)this.events.size(), (long)adapter2.getNumRows());
        this.reprocessAndValidate(tmpDir1, tmpDir2);
        File tmpDir3 = new File(this.tmpDir, "reprocessed3");
        QueryableIndexIndexableAdapter adapter3 = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)tmpDir2)));
        Assert.assertEquals((long)this.events.size(), (long)adapter3.getNumRows());
        this.reprocessAndValidate(tmpDir2, tmpDir3);
    }

    @Test
    public void testSimpleAppend() throws IOException {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)this.persistTmpDir)));
        Assert.assertEquals((long)this.events.size(), (long)adapter.getNumRows());
        this.appendAndValidate(this.persistTmpDir, new File(this.tmpDir, "reprocessed"));
    }

    @Test
    public void testIdempotentAppend() throws IOException {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)this.persistTmpDir)));
        Assert.assertEquals((long)this.events.size(), (long)adapter.getNumRows());
        File tmpDir1 = new File(this.tmpDir, "reprocessed1");
        this.appendAndValidate(this.persistTmpDir, tmpDir1);
        File tmpDir2 = new File(this.tmpDir, "reprocessed2");
        QueryableIndexIndexableAdapter adapter2 = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)tmpDir1)));
        Assert.assertEquals((long)this.events.size(), (long)adapter2.getNumRows());
        this.appendAndValidate(tmpDir1, tmpDir2);
        File tmpDir3 = new File(this.tmpDir, "reprocessed3");
        QueryableIndexIndexableAdapter adapter3 = new QueryableIndexIndexableAdapter(this.closer.closeLater(IndexIO.loadIndex((File)tmpDir2)));
        Assert.assertEquals((long)this.events.size(), (long)adapter3.getNumRows());
        this.appendAndValidate(tmpDir2, tmpDir3);
    }
}

