/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import io.druid.segment.CloserRule;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CloserRuleTest {
    @Rule
    public final CloserRule closer = new CloserRule(true);

    @Test
    public void testCloses() throws Throwable {
        CloserRule closer = new CloserRule(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        });
        this.run(closer, Runnables.doNothing());
        Assert.assertTrue((boolean)closed.get());
    }

    @Test
    public void testAutoCloses() throws Throwable {
        CloserRule closer = new CloserRule(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        closer.closeLater(new AutoCloseable(){

            @Override
            public void close() throws Exception {
                closed.set(true);
            }
        });
        this.run(closer, Runnables.doNothing());
        Assert.assertTrue((boolean)closed.get());
    }

    @Test
    public void testPreservesException() throws Throwable {
        CloserRule closer = new CloserRule(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        });
        String msg = "You can't divide by zero, you can only take the limit of such!";
        Exception ex = null;
        try {
            this.run(closer, new Runnable(){

                @Override
                public void run() {
                    throw new ArithmeticException("You can't divide by zero, you can only take the limit of such!");
                }
            });
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)closed.get());
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)(ex instanceof ArithmeticException));
        Assert.assertEquals((Object)"You can't divide by zero, you can only take the limit of such!", (Object)ex.getMessage());
    }

    @Test
    public void testAddsSuppressed() throws Throwable {
        CloserRule closer = new CloserRule(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        });
        String msg = "You can't divide by zero, you can only take the limit of such!";
        Throwable ex = null;
        try {
            this.run(closer, new Runnable(){

                @Override
                public void run() {
                    throw new ArithmeticException("You can't divide by zero, you can only take the limit of such!");
                }
            });
        }
        catch (Throwable e) {
            ex = e;
        }
        Assert.assertTrue((boolean)closed.get());
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)(ex instanceof ArithmeticException));
        Assert.assertEquals((Object)"You can't divide by zero, you can only take the limit of such!", (Object)ex.getMessage());
        Assert.assertEquals((Object)ImmutableList.of((Object)"You can't triple stamp a double stamp!"), (Object)Lists.transform(Arrays.asList(ex.getSuppressed()), (Function)new Function<Throwable, String>(){

            @Nullable
            public String apply(@Nullable Throwable input) {
                if (input == null) {
                    return null;
                }
                return input.getSuppressed()[0].getMessage();
            }
        }));
    }

    @Test
    public void testThrowsCloseException() {
        CloserRule closer = new CloserRule(true);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        Throwable ex = null;
        try {
            this.run(closer, Runnables.doNothing());
        }
        catch (Throwable throwable) {
            ex = throwable;
        }
        Assert.assertNotNull((Object)ex);
        ex = ex.getSuppressed()[0];
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)(ex instanceof IOException));
        Assert.assertEquals((Object)"You can't triple stamp a double stamp!", (Object)ex.getMessage());
    }

    @Test
    public void testJustLogs() throws Throwable {
        CloserRule closer = new CloserRule(false);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        this.run(closer, Runnables.doNothing());
    }

    @Test
    public void testJustLogsAnything() throws Throwable {
        CloserRule closer = new CloserRule(false);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        closer.closeLater(new AutoCloseable(){

            @Override
            public void close() throws Exception {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        this.run(closer, Runnables.doNothing());
    }

    @Test
    public void testClosesEverything() {
        final AtomicLong counter = new AtomicLong(0L);
        CloserRule closer = new CloserRule(true);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        List<IOException> ioExceptions = Arrays.asList(new IOException("You can't triple stamp a double stamp!"), null, new IOException("You can't triple stamp a double stamp!"), null, new IOException("You can't triple stamp a double stamp!"), null);
        for (final IOException throwable : ioExceptions) {
            closer.closeLater(new Closeable(){

                @Override
                public void close() throws IOException {
                    counter.incrementAndGet();
                    if (throwable != null) {
                        throw throwable;
                    }
                }
            });
        }
        for (final IOException throwable : ioExceptions) {
            closer.closeLater(new AutoCloseable(){

                @Override
                public void close() throws Exception {
                    counter.incrementAndGet();
                    if (throwable != null) {
                        throw throwable;
                    }
                }
            });
        }
        Throwable ex = null;
        try {
            this.run(closer, Runnables.doNothing());
        }
        catch (Throwable throwable) {
            ex = throwable;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertEquals((long)(ioExceptions.size() * 2), (long)counter.get());
        Assert.assertEquals((long)ioExceptions.size(), (long)ex.getSuppressed().length);
    }

    @Ignore
    @Test(expected=IOException.class)
    public void testCloserException() {
        this.closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("This is a test");
            }
        });
    }

    private void run(CloserRule closer, final Runnable runnable) throws Throwable {
        closer.apply(new Statement(){

            public void evaluate() throws Throwable {
                runnable.run();
            }
        }, Description.createTestDescription((String)CloserRuleTest.class.getCanonicalName(), (String)"baseRunner", (Serializable)UUID.randomUUID())).evaluate();
    }
}

