/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.common.logger.Logger;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CloserRule
implements TestRule {
    private final boolean throwException;
    private static final Logger log = new Logger(CloserRule.class);
    private final List<AutoCloseable> autoCloseables = new LinkedList<AutoCloseable>();

    public CloserRule(boolean throwException) {
        this.throwException = throwException;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Throwable baseThrown = null;
                try {
                    base.evaluate();
                }
                catch (Throwable e) {
                    baseThrown = e;
                }
                finally {
                    Throwable exception = null;
                    for (AutoCloseable autoCloseable : CloserRule.this.autoCloseables) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Exception e) {
                            exception = CloserRule.suppressOrSet(exception, e);
                        }
                    }
                    CloserRule.this.autoCloseables.clear();
                    if (exception != null) {
                        if (CloserRule.this.throwException && baseThrown == null) {
                            throw exception;
                        }
                        if (baseThrown != null) {
                            baseThrown.addSuppressed(exception);
                        } else {
                            log.error(exception, "Exception closing resources", new Object[0]);
                        }
                    }
                    if (baseThrown != null) {
                        throw baseThrown;
                    }
                }
            }
        };
    }

    private static Throwable suppressOrSet(Throwable prior, Throwable other) {
        if (prior == null) {
            prior = new IOException("Error closing resources");
        }
        prior.addSuppressed(other);
        return prior;
    }

    public <T extends AutoCloseable> T closeLater(T autoCloseable) {
        this.autoCloseables.add(autoCloseable);
        return autoCloseable;
    }
}

