/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.WrappedImmutableConciseBitmap;
import io.druid.segment.BitmapOffset;
import io.druid.segment.data.Offset;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import org.junit.Assert;
import org.junit.Test;

public class BitmapOffsetTest {
    @Test
    public void testSanity() throws Exception {
        int[] vals = new int[]{1, 2, 4, 291, 27412, 49120, 212312, 2412101};
        ConciseSet mutableSet = new ConciseSet();
        for (int val : vals) {
            mutableSet.add(val);
        }
        ImmutableConciseSet set = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)mutableSet);
        BitmapOffset offset = new BitmapOffset((BitmapFactory)new ConciseBitmapFactory(), (ImmutableBitmap)new WrappedImmutableConciseBitmap(set));
        int count = 0;
        while (offset.withinBounds()) {
            Assert.assertEquals((long)vals[count], (long)offset.getOffset());
            int cloneCount = count;
            Offset clonedOffset = offset.clone();
            while (clonedOffset.withinBounds()) {
                Assert.assertEquals((long)vals[cloneCount], (long)clonedOffset.getOffset());
                ++cloneCount;
                clonedOffset.increment();
            }
            ++count;
            offset.increment();
        }
        Assert.assertEquals((long)count, (long)vals.length);
    }
}

