/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.collections.StupidPool;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNUnionQueryTest {
    private final QueryRunner runner;

    public TopNUnionQueryTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList retVal = Lists.newArrayList();
        retVal.addAll(QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(TestQueryRunners.getPool(), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (DataSource)QueryRunnerTestHelper.unionDataSource));
        retVal.addAll(QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(2000);
            }
        }), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (DataSource)QueryRunnerTestHelper.unionDataSource));
        return retVal;
    }

    @Test
    public void testTopNUnionQuery() {
        TopNQuery query = new TopNQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.unionDataSource).granularity(QueryRunnerTestHelper.allGran).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg, QueryRunnerTestHelper.hyperUniqueFinalizingPostAgg)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)744L).put((Object)"index", (Object)862719.3151855469).put((Object)"addRowsIndexConstant", (Object)863464.3151855469).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)864209.3151855469).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)744L).put((Object)"index", (Object)768184.4240722656).put((Object)"addRowsIndexConstant", (Object)768929.4240722656).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)769674.4240722656).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)3348L).put((Object)"index", (Object)382426.28929138184).put((Object)"addRowsIndexConstant", (Object)385775.28929138184).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)389124.28929138184).put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, context));
    }
}

