/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BySegmentResultValue;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.JavascriptExtractionFn;
import io.druid.query.extraction.LookupExtractionFn;
import io.druid.query.extraction.LookupExtractor;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.query.extraction.TimeFormatExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.topn.AlphaNumericTopNMetricSpec;
import io.druid.query.topn.BySegmentTopNResultValue;
import io.druid.query.topn.InvertedTopNMetricSpec;
import io.druid.query.topn.LexicographicTopNMetricSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNQueryRunnerTest {
    private final QueryRunner<Result<TopNResultValue>> runner;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        ArrayList retVal = Lists.newArrayList();
        retVal.addAll(QueryRunnerTestHelper.makeQueryRunners(new TopNQueryRunnerFactory(TestQueryRunners.getPool(), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
        retVal.addAll(QueryRunnerTestHelper.makeQueryRunners(new TopNQueryRunnerFactory(new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(20000);
            }
        }), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
        return QueryRunnerTestHelper.transformToConstructionFeeder(retVal);
    }

    public TopNQueryRunnerTest(QueryRunner<Result<TopNResultValue>> runner) {
        this.runner = runner;
    }

    private Sequence<Result<TopNResultValue>> assertExpectedResults(Iterable<Result<TopNResultValue>> expectedResults, TopNQuery query) {
        Sequence<Result<TopNResultValue>> retval = this.runWithMerge(query);
        TestHelper.assertExpectedResults(expectedResults, retval);
        return retval;
    }

    private Sequence<Result<TopNResultValue>> runWithMerge(TopNQuery query) {
        return this.runWithMerge(query, (Map<String, Object>)ImmutableMap.of());
    }

    private Sequence<Result<TopNResultValue>> runWithMerge(TopNQuery query, Map<String, Object> context) {
        TopNQueryQueryToolChest chest = new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        QueryRunner mergeRunner = chest.mergeResults(this.runner);
        return mergeRunner.run((Query)query, context);
    }

    @Test
    public void testFullOnTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNOverPostAggs() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("addRowsIndexConstant").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNOverUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("uniques").threshold(3).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverMissingUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("uniques").threshold(3).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(new HyperUniquesAggregatorFactory("uniques", "missingUniques"))).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"uniques", (Object)0).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"uniques", (Object)0).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"uniques", (Object)0).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNBySegment() {
        HashMap<String, Object> specialContext = new HashMap<String, Object>();
        specialContext.put("bySegment", "true");
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).context(specialContext).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"index", (Object)5351.814697265625, (Object)"market", (Object)"total_market", (Object)"uniques", (Object)2.000977198748901, (Object)"rows", (Object)4L), ImmutableMap.of((Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"index", (Object)4875.669677734375, (Object)"market", (Object)"upfront", (Object)"uniques", (Object)2.000977198748901, (Object)"rows", (Object)4L), ImmutableMap.of((Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"index", (Object)2231.8768157958984, (Object)"market", (Object)"spot", (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)18L)))));
        Sequence<Result<TopNResultValue>> results = this.runWithMerge(query, specialContext);
        List resultList = Sequences.toList((Sequence)Sequences.map(results, (Function)new Function<Result<TopNResultValue>, Result<BySegmentTopNResultValue>>(){

            @Nullable
            public Result<BySegmentTopNResultValue> apply(Result<TopNResultValue> input) {
                Object val = input.getValue();
                if (val instanceof BySegmentResultValue) {
                    BySegmentResultValue bySegVal = (BySegmentResultValue)val;
                    List results = bySegVal.getResults();
                    return new Result(input.getTimestamp(), (Object)new BySegmentTopNResultValue(Lists.transform((List)results, (Function)new Function<Object, Result<TopNResultValue>>(){

                        @Nullable
                        public Result<TopNResultValue> apply(@Nullable Object input) {
                            Result result;
                            Object resVal;
                            if (Preconditions.checkNotNull((Object)input) instanceof Result && (resVal = (result = (Result)input).getValue()) instanceof TopNResultValue) {
                                return new Result(result.getTimestamp(), (Object)((TopNResultValue)resVal));
                            }
                            throw new IAE("Bad input: [%s]", new Object[]{input});
                        }
                    }), bySegVal.getSegmentId(), bySegVal.getInterval()));
                }
                throw new ISE("Bad type", new Object[0]);
            }
        }), (List)Lists.newArrayList());
        Result result = (Result)resultList.get(0);
        TestHelper.assertExpectedResults(expectedResults, ((BySegmentTopNResultValue)result.getValue()).getResults());
    }

    @Test
    public void testTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNByUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new NumericTopNMetricSpec("uniques")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithOrFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market", new String[]{"upfront", "spot"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithOrFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market", new String[]{"upfront"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "upfront").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)2L, (Object)"index", (Object)2591.68359375, (Object)"addRowsIndexConstant", (Object)2594.68359375, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)2L, (Object)"index", (Object)2508.39599609375, (Object)"addRowsIndexConstant", (Object)2511.39599609375, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)2L, (Object)"index", (Object)220.63774871826172, (Object)"addRowsIndexConstant", (Object)223.63774871826172, (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithFilter2OneDay() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval((Object)"2011-04-01T00:00:00.000Z/2011-04-02T00:00:00.000Z")))).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(1447.34116).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(1449.34116).doubleValue(), (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(1314.839715).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(1316.839715).doubleValue(), (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(109.705815).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(111.705815).doubleValue(), (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentFilterInOr() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "total_market", new String[]{"upfront", "billyblank"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "billyblank").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap context = new HashMap();
        this.assertExpectedResults(Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue((List)Lists.newArrayList()))}), query);
    }

    @Test
    public void testTopNWithNonExistentFilterMultiDim() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields((List)Lists.newArrayList((Object[])new DimFilter[]{Druids.newSelectorDimFilterBuilder().dimension("market").value("billyblank").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("mezzanine").build()})).build();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters((DimFilter)andDimFilter).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        this.assertExpectedResults(Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue((List)Lists.newArrayList()))}), query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "m").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        this.assertExpectedResults(Sequences.toList(this.runWithMerge(new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build()), (List)Lists.newArrayList()), query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "m", new String[]{"a", "b"}).dimension("quality").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        this.assertExpectedResults(Sequences.toList(this.runWithMerge(new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("quality", "mezzanine", new String[]{"automotive", "business"}).dimension("quality").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build()), (List)Lists.newArrayList()), query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter3() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "a").dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        ArrayList expectedResults = Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182))))});
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter4() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "a", new String[]{"b"}).dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        ArrayList expectedResults = Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)4L, (Object)"index", (Object)514.868408203125, (Object)"addRowsIndexConstant", (Object)519.868408203125, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"placementish", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"b", (Object)"rows", (Object)2L, (Object)"index", (Object)231.557373046875, (Object)"addRowsIndexConstant", (Object)234.557373046875, (Object)"uniques", (Object)1.0002442201269182))))});
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter5() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "preferred").dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        ArrayList expectedResults = Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)26L, (Object)"index", (Object)12459.361190795898, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"placementish", (Object)"p", (Object)"rows", (Object)6L, (Object)"index", (Object)5407.213653564453, (Object)"addRowsIndexConstant", (Object)5414.213653564453, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"m", (Object)"rows", (Object)6L, (Object)"index", (Object)5320.717338562012, (Object)"addRowsIndexConstant", (Object)5327.717338562012, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)422.3440856933594, (Object)"addRowsIndexConstant", (Object)427.3440856933594, (Object)"uniques", (Object)2.000977198748901))))});
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("doesn't exist").metric("index").threshold(1).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("doesn't exist", null);
                this.put("rows", 26L);
                this.put("index", 12459.361190795898);
                this.put("addRowsIndexConstant", 12486.361190795898);
                this.put("uniques", 9.019833517963864);
            }
        }))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentDimensionAndActualFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("market", "upfront").dimension("doesn't exist").metric("index").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("doesn't exist", null);
                this.put("rows", 4L);
                this.put("index", 4875.669677734375);
                this.put("addRowsIndexConstant", 4880.669677734375);
                this.put("uniques", 2.000977198748901);
            }
        }))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentDimensionAndNonExistentFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("doesn't exist", null).dimension("doesn't exist").metric("index").threshold(1).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("doesn't exist", null);
                this.put("rows", 26L);
                this.put("index", 12459.361190795898);
                this.put("addRowsIndexConstant", 12486.361190795898);
                this.put("uniques", 9.019833517963864);
            }
        }))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographic() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new LexicographicTopNMetricSpec("")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new LexicographicTopNMetricSpec("spot")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicWithNonExistingPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new LexicographicTopNMetricSpec("t")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNInvertedLexicographicWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("upfront"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNInvertedLexicographicWithNonExistingPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("u"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionToOne() throws IOException {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new JavascriptExtractionFn("function(f) { return \"POTATO\"; }", false), null)).metric("rows").threshold(10).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        QueryGranularity gran = QueryGranularity.DAY;
        TimeseriesQuery tsQuery = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"addRowsIndexConstant", (Object)504542.5071372986, (Object)"index", (Object)503332.5071372986, (Object)"market", (Object)"POTATO", (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)1209L)))));
        List list = Sequences.toList(this.runWithMerge(query), new ArrayList());
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((String)"Didn't merge results", (long)((TopNResultValue)((Result)list.get(0)).getValue()).getValue().size(), (long)1L);
        TestHelper.assertExpectedResults(expectedResults, list, "Failed to match");
    }

    @Test
    public void testTopNCollapsingDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("quality", "quality", (ExtractionFn)new RegexDimExtractionFn(".(.)"), null)).metric("index").threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"quality", (Object)"e", (Object)"rows", (Object)558L, (Object)"index", (Object)246645.1204032898, (Object)"addRowsIndexConstant", (Object)247204.1204032898), ImmutableMap.of((Object)"quality", (Object)"r", (Object)"rows", (Object)372L, (Object)"index", (Object)222051.08961486816, (Object)"addRowsIndexConstant", (Object)222424.08961486816)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNOptimalWithReplaceMissing() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot0", (Object)"total_market", (Object)"1total_market0", (Object)"upfront", (Object)"3upfront0")), false, "MISSING", true), null)).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"2spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"1total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"3upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNUnOptimalWithReplaceMissing() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot0", (Object)"total_market", (Object)"1total_market0", (Object)"upfront", (Object)"3upfront0")), false, "MISSING", false), null)).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"2spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"1total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"3upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNOptimal() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot0", (Object)"total_market", (Object)"1total_market0", (Object)"upfront", (Object)"3upfront0")), true, null, true), null)).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"2spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"1total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"3upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNUnOptimal() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"spot0", (Object)"total_market", (Object)"total_market0", (Object)"upfront", (Object)"upfront0")), true, null, false), null)).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionOptimalNamespace() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot", (Object)"total_market", (Object)"3total_market", (Object)"upfront", (Object)"1upfront")), true, null, true), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec(null)).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"1upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"2spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"3total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionUnOptimalNamespace() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot", (Object)"total_market", (Object)"3total_market", (Object)"upfront", (Object)"1upfront")), true, null, false), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec(null)).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"1upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"2spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"3total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionOptimalNamespaceWithRunner() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot", (Object)"total_market", (Object)"3total_market", (Object)"upfront", (Object)"1upfront")), true, null, true), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec(null)).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"1upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"2spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"3total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec(null)).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNLexicographicDimExtraction2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("..(.)"), null)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec(null))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"o", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"f", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec("s")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionWithSortingPreservedAndPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[0];
            }

            public String apply(String value) {
                return value.substring(0, 1);
            }

            public boolean preservesOrdering() {
                return true;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        }, null)).metric((TopNMetricSpec)new LexicographicTopNMetricSpec("s")).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNLexicographicDimExtractionWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)"), null)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("u"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNLexicographicDimExtractionWithPreviousStop2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("..(.)"), null)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new LexicographicTopNMetricSpec("p"))).threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"o", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"f", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNullProducingDimExtractionFn() {
        DimExtractionFn nullStringDimExtraction = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("total_market") ? null : dimValue;
            }

            public boolean preservesOrdering() {
                return false;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        };
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)nullStringDimExtraction, null)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), new LinkedHashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 4L);
                this.put("index", 5351.814697265625);
                this.put("addRowsIndexConstant", 5356.814697265625);
                this.put("uniques", 2.000977198748901);
            }
        }, ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithEmptyStringProducingDimExtractionFn() {
        DimExtractionFn emptyStringDimExtraction = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("total_market") ? "" : dimValue;
            }

            public boolean preservesOrdering() {
                return false;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        };
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)emptyStringDimExtraction, null)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), new LinkedHashMap<String, Object>(){
            {
                this.put("market", "");
                this.put("rows", 4L);
                this.put("index", 5351.814697265625);
                this.put("addRowsIndexConstant", 5356.814697265625);
                this.put("uniques", 2.000977198748901);
            }
        }, ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNQuery() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("index"))).threshold(3).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.8768157958984, (Object)"addRowsIndexConstant", (Object)2250.8768157958984, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"addRowsIndexConstant", (Object)4880.669677734375, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814697265625, (Object)"addRowsIndexConstant", (Object)5356.814697265625, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNQueryByComplexMetric() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric((TopNMetricSpec)new NumericTopNMetricSpec("numVals")).threshold(10).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)"market"), false)})).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"numVals", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"numVals", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"numVals", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDependentPostAgg() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg, QueryRunnerTestHelper.hyperUniqueFinalizingPostAgg)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)216053.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)192420.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)97282.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNBySegmentResults() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg)).context((Map)ImmutableMap.of((Object)"finalize", (Object)true, (Object)"bySegment", (Object)true)).build();
        TopNResultValue topNResult = new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)216053.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)192420.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)97282.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()));
        List<Result> expectedResults = Collections.singletonList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Collections.singletonList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)topNResult)), "testSegment", new Interval((Object)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z"))));
        Sequence<Result<TopNResultValue>> results = this.runWithMerge(query);
        for (Result result : (ArrayList)Sequences.toList(results, new ArrayList())) {
            Assert.assertEquals((Object)result.getValue(), (Object)result.getValue());
        }
    }

    @Test
    public void testTopNWithTimeColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.jsCountIfTimeGreaterThan, QueryRunnerTestHelper.__timeLongSum)).granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("ntimestamps").threshold(3).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"ntimestamps", (Object)9.0, (Object)"sumtime", (Object)23429865600000L), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"ntimestamps", (Object)2.0, (Object)"sumtime", (Object)5206636800000L), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"ntimestamps", (Object)2.0, (Object)"sumtime", (Object)5206636800000L)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNTimeExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null), null)).metric("index").threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"dayOfWeek", (Object)"Wednesday", (Object)"rows", (Object)182L, (Object)"index", (Object)76010.28100585938, (Object)"addRowsIndexConstant", (Object)76193.28100585938), ImmutableMap.of((Object)"dayOfWeek", (Object)"Thursday", (Object)"rows", (Object)182L, (Object)"index", (Object)75203.26300811768, (Object)"addRowsIndexConstant", (Object)75386.26300811768)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverNullDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("null_column").metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap map = Maps.newHashMap();
        map.put("null_column", null);
        map.put("rows", 1209L);
        map.put("index", 503332.5071372986);
        map.put("addRowsIndexConstant", 504542.5071372986);
        map.put("uniques", 9.019833517963864);
        map.put("maxIndex", 1870.06103515625);
        map.put("minIndex", 59.02102279663086);
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(map))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverNullDimensionWithFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("null_column").filters((DimFilter)new SelectorDimFilter("null_column", null)).metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        HashMap map = Maps.newHashMap();
        map.put("null_column", null);
        map.put("rows", 1209L);
        map.put("index", 503332.5071372986);
        map.put("addRowsIndexConstant", 504542.5071372986);
        map.put("uniques", 9.019833517963864);
        map.put("maxIndex", 1870.06103515625);
        map.put("minIndex", 59.02102279663086);
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(map))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverPartialNullDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryGranularity.ALL).dimension("partial_null_column").metric("uniques").threshold(1000).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).build();
        HashMap map = Maps.newHashMap();
        map.put("partial_null_column", null);
        map.put("rows", 22L);
        map.put("index", 7583.691513061523);
        map.put("uniques", 9.019833517963864);
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(map, ImmutableMap.of((Object)"partial_null_column", (Object)"value", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverPartialNullDimensionWithFilterOnNullValue() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryGranularity.ALL).dimension("partial_null_column").metric("uniques").filters((DimFilter)new SelectorDimFilter("partial_null_column", null)).threshold(1000).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).build();
        HashMap map = Maps.newHashMap();
        map.put("partial_null_column", null);
        map.put("rows", 22L);
        map.put("index", 7583.691513061523);
        map.put("uniques", 9.019833517963864);
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(map))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverPartialNullDimensionWithFilterOnNOTNullValue() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryGranularity.ALL).dimension("partial_null_column").metric("uniques").filters((DimFilter)new SelectorDimFilter("partial_null_column", "value")).threshold(1000).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"partial_null_column", (Object)"value", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669677734375, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testAlphaNumericTopNWithNullPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryGranularity.ALL).dimension("market").metric((TopNMetricSpec)new AlphaNumericTopNMetricSpec(null)).threshold(2).intervals(QueryRunnerTestHelper.secondOnly).aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-02T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)9L), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)2L)))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((Query)query, new HashMap()));
    }
}

