/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.caliper.Param;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import com.google.common.collect.Lists;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNBinaryFn;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNResultMerger;
import io.druid.query.topn.TopNResultValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;

public class TopNBinaryFnBenchmark
extends SimpleBenchmark {
    @Param(value={"1", "5", "10", "15"})
    int aggCount;
    @Param(value={"1", "5", "10", "15"})
    int postAggCount;
    @Param(value={"1000", "10000"})
    int threshold;
    Result<TopNResultValue> result1;
    Result<TopNResultValue> result2;
    TopNBinaryFn fn;

    public static void main(String[] args) throws Exception {
        Runner.main(TopNBinaryFnBenchmark.class, (String[])args);
    }

    protected void setUp() throws Exception {
        ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
        FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
        FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
        ArrayList<Object> aggregatorFactories = new ArrayList<Object>();
        aggregatorFactories.add(new CountAggregatorFactory("rows"));
        aggregatorFactories.add(new LongSumAggregatorFactory("index", "index"));
        for (int i = 1; i < this.aggCount; ++i) {
            aggregatorFactories.add(new CountAggregatorFactory("rows" + i));
        }
        ArrayList<ArithmeticPostAggregator> postAggregators = new ArrayList<ArithmeticPostAggregator>();
        for (int i = 0; i < this.postAggCount; ++i) {
            postAggregators.add(new ArithmeticPostAggregator("addrowsindexconstant" + i, "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{constant, rowsPostAgg, indexPostAgg})));
        }
        DateTime currTime = new DateTime();
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.threshold; ++i) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("testdim", "" + i);
            res.put("rows", 1L);
            for (int j = 0; j < this.aggCount; ++j) {
                res.put("rows" + j, 1L);
            }
            res.put("index", 1L);
            list.add(res);
        }
        this.result1 = new Result(currTime, (Object)new TopNResultValue(list));
        ArrayList list2 = new ArrayList();
        for (int i = 0; i < this.threshold; ++i) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("testdim", "" + i);
            res.put("rows", 2L);
            for (int j = 0; j < this.aggCount; ++j) {
                res.put("rows" + j, 2L);
            }
            res.put("index", 2L);
            list2.add(res);
        }
        this.result2 = new Result(currTime, (Object)new TopNResultValue(list2));
        this.fn = new TopNBinaryFn(TopNResultMerger.identity, QueryGranularity.ALL, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("index"), 100, aggregatorFactories, postAggregators);
    }

    public void timeMerge(int nReps) {
        for (int i = 0; i < nReps; ++i) {
            this.fn.apply(this.result1, this.result2);
        }
    }
}

