/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.granularity.PeriodGranularity;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerTest {
    public static final Map<String, Object> CONTEXT = ImmutableMap.of();
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(QueryRunnerTestHelper.makeQueryRunners(new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
    }

    public TimeseriesQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Test
    public void testFullOnTimeseries() {
        QueryGranularity gran = QueryGranularity.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        DateTime expectedEarliest = new DateTime((Object)"2011-01-12");
        DateTime expectedLast = new DateTime((Object)"2011-04-15");
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        int count = 0;
        Result lastResult = null;
        Iterator i$ = results.iterator();
        while (i$.hasNext()) {
            Result result;
            lastResult = result = (Result)i$.next();
            Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
            Assert.assertFalse((String)String.format("Timestamp[%s] > expectedLast[%s]", result.getTimestamp(), expectedLast), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0L : 13L), (long)value.getLongMetric("rows"));
            Assert.assertEquals((String)result.toString(), (Object)QueryRunnerTestHelper.expectedFullOnIndexValues[count], (Object)String.valueOf(value.getDoubleMetric("index")));
            Assert.assertEquals((String)result.toString(), (double)(new Double(QueryRunnerTestHelper.expectedFullOnIndexValues[count]) + (double)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0L : 13L) + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)0.0);
            Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0.0 : 9.0), (double)0.02);
            expectedEarliest = gran.toDateTime(gran.next(expectedEarliest.getMillis()));
            ++count;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testFullOnTimeseriesMaxMin() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryGranularity.ALL).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"))).build();
        DateTime expectedEarliest = new DateTime((Object)"2011-01-12");
        DateTime expectedLast = new DateTime((Object)"2011-04-15");
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)String.format("Timestamp[%s] > expectedLast[%s]", result.getTimestamp(), expectedLast), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.06103515625, (double)value.getDoubleMetric("maxIndex"), (double)0.0);
        Assert.assertEquals((String)result.toString(), (double)59.02102279663086, (double)value.getDoubleMetric("minIndex"), (double)0.0);
    }

    @Test
    public void testFullOnTimeseriesWithFilter() {
        QueryGranularity gran = QueryGranularity.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "upfront").intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.qualityUniques)).build();
        Assert.assertEquals((Object)Druids.newSelectorDimFilterBuilder().dimension("market").value("upfront").build(), (Object)query.getDimensionsFilter());
        DateTime expectedEarliest = new DateTime((Object)"2011-01-12");
        DateTime expectedLast = new DateTime((Object)"2011-04-15");
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        for (Result result : results) {
            Assert.assertEquals((String)result.toString(), (Object)expectedEarliest, (Object)result.getTimestamp());
            Assert.assertFalse((String)String.format("Timestamp[%s] > expectedLast[%s]", result.getTimestamp(), expectedLast), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0L : 2L), (long)value.getLongMetric("rows"));
            Assert.assertEquals((String)result.toString(), (double)(QueryRunnerTestHelper.skippedDay.equals((Object)result.getTimestamp()) ? 0.0 : 2.0), (double)value.getDoubleMetric("uniques"), (double)0.01);
            expectedEarliest = gran.toDateTime(gran.next(expectedEarliest.getMillis()));
        }
    }

    @Test
    public void testTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithTimeZone() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).granularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.forID((String)"America/Los_Angeles"))).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-03-31", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L))), new Result(new DateTime((Object)"2011-04-01T", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVaryingGran() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Arrays.asList(new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = Sequences.toList((Sequence)this.runner.run((Query)query1, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity("DAY").intervals(Arrays.asList(new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults2 = Arrays.asList(new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = Sequences.toList((Sequence)this.runner.run((Query)query2, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesGranularityNotAlignedOnSegmentBoundariesWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P7D"), null, DateTimeZone.forID((String)"America/Los_Angeles"))).intervals(Arrays.asList(new Interval((Object)"2011-01-12T00:00:00.000-08:00/2011-01-20T00:00:00.000-08:00"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-01-06T00:00:00.000-08:00", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6071L))), new Result(new DateTime((Object)"2011-01-13T00:00:00.000-08:00", DateTimeZone.forID((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)91L, (Object)"idx", (Object)33382L))));
        List results1 = Sequences.toList((Sequence)this.runner.run((Query)query1, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryZeroFilling() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity(QueryGranularity.HOUR).intervals(Arrays.asList(new Interval((Object)"2011-04-14T00:00:00.000Z/2011-05-01T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).build();
        ArrayList lotsOfZeroes = Lists.newArrayList();
        for (Long millis : QueryGranularity.HOUR.iterable(new DateTime((Object)"2011-04-14T01").getMillis(), new DateTime((Object)"2011-04-15").getMillis())) {
            lotsOfZeroes.add(new Result(new DateTime((Object)millis), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"idx", (Object)0L))));
        }
        ArrayList expectedResults1 = Lists.newArrayList((Iterable)Iterables.concat(Arrays.asList(new Result(new DateTime((Object)"2011-04-14T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4907L)))), (Iterable)lotsOfZeroes, Arrays.asList(new Result(new DateTime((Object)"2011-04-15T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))))));
        List results1 = Sequences.toList((Sequence)this.runner.run((Query)query1, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryGranularityNotAlignedWithRollupGranularity() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((QueryGranularity)new PeriodGranularity(new Period((Object)"PT1H"), new DateTime(60000L), DateTimeZone.UTC)).intervals(Arrays.asList(new Interval((Object)"2011-04-15T00:00:00.000Z/2012"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-04-14T23:01Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))));
        List results1 = Sequences.toList((Sequence)this.runner.run((Query)query1, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesWithVaryingGranWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Arrays.asList(new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = Sequences.toList((Sequence)this.runner.run((Query)query1, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity("DAY").intervals(Arrays.asList(new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();
        List expectedResults2 = Arrays.asList(new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = Sequences.toList((Sequence)this.runner.run((Query)query2, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesQueryBeyondTimeRangeOfData() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(new Interval((Object)"2015-01-01/2015-01-10")))).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).build();
        List<Object> expectedResults = Arrays.asList(new Object[0]);
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOrFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "spot", new String[]{"upfront", "total_market"}).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithRegexFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new RegexDimFilter("market", "^.p.*$")).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "spot").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "upfront").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2681L, (Object)"addRowsIndexConstant", (Object)2684.0, (Object)"uniques", (Object)2.000977198748901))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2193L, (Object)"addRowsIndexConstant", (Object)2196.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter3() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "total_market").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2836L, (Object)"addRowsIndexConstant", (Object)2839.0, (Object)"uniques", (Object)2.000977198748901))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2514L, (Object)"addRowsIndexConstant", (Object)2517.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilterAndOr() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newOrDimFilterBuilder().fields("quality", "automotive", new String[]{"business"}).build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilter() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("automotive").build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(135.885094).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(137.885094).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(147.425935).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(149.425935).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOtherMultiDimFilter() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("business").build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(118.57034).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(120.57034).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(112.987027).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(114.987027).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterInOr() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "spot", new String[]{"upfront", "total_market", "billyblank"}).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityUniques)).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDimAndOr() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newOrDimFilterBuilder().fields("quality", "automotive", new String[]{"business", "billyblank"}).build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("bobby", "billy").intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimensionSkipBuckets() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("bobby", "billy").intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)"true")).build();
        List<Object> expectedResults = Arrays.asList(new Object[0]);
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, new HashMap()), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNullFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("bobby", null).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, new HashMap()), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInvertedFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("bobby", "sally"))).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, new HashMap()), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("market", "billy").intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("billy").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("business").build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))), new Result(new DateTime((Object)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)0L, (Object)"index", (Object)0.0, (Object)"addRowsIndexConstant", (Object)1.0, (Object)"uniques", (Object)0.0))));
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregator() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.indexDoubleSum, (Object)QueryRunnerTestHelper.jsIndexSumIfPlacementishA, (Object)QueryRunnerTestHelper.jsPlacementishCount)).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(new DateTime((Object)((Interval)QueryRunnerTestHelper.firstToThird.getIntervals().get(0)).getStart()), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)12459.361190795898, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)52.0))));
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregatorAndAlsoRegularFilters() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).filters("placementish", "a").intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.indexDoubleSum, (Object)QueryRunnerTestHelper.jsIndexSumIfPlacementishA, (Object)QueryRunnerTestHelper.jsPlacementishCount)).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(new DateTime((Object)((Interval)QueryRunnerTestHelper.firstToThird.getIntervals().get(0)).getStart()), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)283.31103515625, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)4.0))));
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("placementish", "preferred").intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run((Query)Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build(), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("placementish", "a").intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run((Query)Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters("quality", "automotive").intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build(), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr1() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("placementish").value("a").build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        AndDimFilter andDimFilter2 = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newSelectorDimFilterBuilder().dimension("quality").value("automotive").build())).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run((Query)Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build(), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr2() {
        AndDimFilter andDimFilter = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newOrDimFilterBuilder().fields("placementish", "a", new String[]{"b"}).build())).build();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        AndDimFilter andDimFilter2 = Druids.newAndDimFilterBuilder().fields(Arrays.asList(Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build(), Druids.newOrDimFilterBuilder().fields("quality", "automotive", new String[]{"business"}).build())).build();
        List expectedResults = Sequences.toList((Sequence)this.runner.run((Query)Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.firstToThird).aggregators(QueryRunnerTestHelper.commonAggregators).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build(), CONTEXT), (List)Lists.newArrayList());
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAgg() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)Druids.newSelectorDimFilterBuilder().dimension("market").value("spot").build())})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)18L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNotNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)Druids.newSelectorDimFilterBuilder().dimension("abraKaDabra").value("Lol").build())})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)0L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)Druids.newSelectorDimFilterBuilder().dimension("abraKaDabra").value(null).build())})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggValueNotPresent() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)Druids.newSelectorDimFilterBuilder().dimension("market").value("LolLol").build()))})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggInvertedNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonAggregators, (Iterable)Lists.newArrayList((Object[])new FilteredAggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)Druids.newSelectorDimFilterBuilder().dimension("market").value(null).build()))})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithTimeColumn() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.jsCountIfTimeGreaterThan, QueryRunnerTestHelper.__timeLongSum)).granularity(QueryRunnerTestHelper.allGran).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"ntimestamps", (Object)13.0, (Object)"sumtime", (Object)33843139200000L))));
        List actualResults = Sequences.toList((Sequence)this.runner.run((Query)query, CONTEXT), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }
}

