/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Druids;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Test;

public class TimeseriesQueryRunnerBonusTest {
    @Test
    public void testOneRowAtATime() throws Exception {
        OnheapIncrementalIndex oneRowIndex = new OnheapIncrementalIndex(new DateTime((Object)"2012-01-01T00:00:00Z").getMillis(), QueryGranularity.NONE, new AggregatorFactory[0], 1000);
        oneRowIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        List<Result<TimeseriesResultValue>> results = TimeseriesQueryRunnerBonusTest.runTimeseriesCount((IncrementalIndex)oneRowIndex);
        Assert.assertEquals((String)"index size", (int)1, (int)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (int)1, (int)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)new DateTime((Object)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)1L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
        oneRowIndex.add((InputRow)new MapBasedInputRow(new DateTime((Object)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"y")));
        results = TimeseriesQueryRunnerBonusTest.runTimeseriesCount((IncrementalIndex)oneRowIndex);
        Assert.assertEquals((String)"index size", (int)2, (int)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (int)1, (int)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)new DateTime((Object)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)2L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
    }

    private static List<Result<TimeseriesResultValue>> runTimeseriesCount(IncrementalIndex index) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = TimeseriesQueryRunnerBonusTest.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(index, null));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(QueryGranularity.ALL).intervals((List)ImmutableList.of((Object)new Interval((Object)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).build();
        HashMap context = new HashMap();
        return Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
    }

    private static <T> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, Query<T>> factory, Segment adapter) {
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

