/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TimeseriesQueryQueryToolChestTest {
    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new TimeseriesQueryQueryToolChest(null).getCacheStrategy(new TimeseriesQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)new Interval((Object)"2015-01-01/2015-01-02"))), null, QueryGranularity.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1")), null, null));
        Result result = new Result(new DateTime(123L), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric1", (Object)2)));
        Object preparedValue = strategy.prepareForCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }
}

