/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.timeline.LogicalSegment;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TimeBoundaryQueryQueryToolChestTest {
    @Test
    public void testFilterSegments() throws Exception {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(null, Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T02/PT1H");
            }
        }));
        Assert.assertEquals((long)segments.size(), (long)3L);
        List<LogicalSegment> expected = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T02/PT1H");
            }
        });
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new TimeBoundaryQueryQueryToolChest().getCacheStrategy(new TimeBoundaryQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)new Interval((Object)"2015-01-01/2015-01-02"))), null, null));
        Result result = new Result(new DateTime(123L), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime(0L).toString(), (Object)"maxTime", (Object)new DateTime((Object)"2015-01-01").toString())));
        Object preparedValue = strategy.prepareForCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }
}

