/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.spec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.SegmentDescriptor;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.CountAggregator;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.spec.SpecificSegmentQueryRunner;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultBuilder;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.SegmentMissingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Test;

public class SpecificSegmentQueryRunnerTest {
    @Test
    public void testRetry() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        SegmentDescriptor descriptor = new SegmentDescriptor(new Interval((Object)"2012-01-01T00:00:00Z/P1D"), "version", 0);
        SpecificSegmentQueryRunner queryRunner = new SpecificSegmentQueryRunner(new QueryRunner(){

            public Sequence run(Query query, Map responseContext) {
                return new Sequence(){

                    public Object accumulate(Object initValue, Accumulator accumulator) {
                        throw new SegmentMissingException("FAILSAUCE", new Object[0]);
                    }

                    public Yielder<Object> toYielder(Object initValue, YieldingAccumulator accumulator) {
                        return null;
                    }
                };
            }
        }, new SpecificSegmentSpec(descriptor));
        HashMap responseContext = Maps.newHashMap();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("foo").granularity(QueryGranularity.ALL).intervals((List)ImmutableList.of((Object)new Interval((Object)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).build();
        Sequence results = queryRunner.run((Query)query, (Map)responseContext);
        Sequences.toList((Sequence)results, (List)Lists.newArrayList());
        Object missingSegments = responseContext.get(Result.MISSING_SEGMENTS_KEY);
        Assert.assertTrue((missingSegments != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(missingSegments instanceof List));
        Object segmentDesc = ((List)missingSegments).get(0);
        Assert.assertTrue((boolean)(segmentDesc instanceof SegmentDescriptor));
        SegmentDescriptor newDesc = (SegmentDescriptor)mapper.readValue(mapper.writeValueAsString(segmentDesc), SegmentDescriptor.class);
        Assert.assertEquals((Object)descriptor, (Object)newDesc);
    }

    @Test
    public void testRetry2() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        SegmentDescriptor descriptor = new SegmentDescriptor(new Interval((Object)"2012-01-01T00:00:00Z/P1D"), "version", 0);
        TimeseriesResultBuilder builder = new TimeseriesResultBuilder(new DateTime((Object)"2012-01-01T00:00:00Z"));
        CountAggregator rows = new CountAggregator("rows");
        rows.aggregate();
        builder.addMetric((Aggregator)rows);
        final Result value = builder.build();
        SpecificSegmentQueryRunner queryRunner = new SpecificSegmentQueryRunner(new QueryRunner(){

            public Sequence run(Query query, Map responseContext) {
                return Sequences.withEffect((Sequence)Sequences.simple(Arrays.asList(value)), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        throw new SegmentMissingException("FAILSAUCE", new Object[0]);
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
            }
        }, new SpecificSegmentSpec(descriptor));
        HashMap responseContext = Maps.newHashMap();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("foo").granularity(QueryGranularity.ALL).intervals((List)ImmutableList.of((Object)new Interval((Object)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).build();
        Sequence results = queryRunner.run((Query)query, (Map)responseContext);
        List res = Sequences.toList((Sequence)results, (List)Lists.newArrayList());
        Assert.assertEquals((int)1, (int)res.size());
        Result theVal = (Result)res.get(0);
        Assert.assertTrue((1L == ((TimeseriesResultValue)theVal.getValue()).getLongMetric("rows") ? 1 : 0) != 0);
        Object missingSegments = responseContext.get(Result.MISSING_SEGMENTS_KEY);
        Assert.assertTrue((missingSegments != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(missingSegments instanceof List));
        Object segmentDesc = ((List)missingSegments).get(0);
        Assert.assertTrue((boolean)(segmentDesc instanceof SegmentDescriptor));
        SegmentDescriptor newDesc = (SegmentDescriptor)mapper.readValue(mapper.writeValueAsString(segmentDesc), SegmentDescriptor.class);
        Assert.assertEquals((Object)descriptor, (Object)newDesc);
    }
}

