/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.spec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.SegmentDescriptor;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.MultipleSpecificSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class QuerySegmentSpecTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testSerializationLegacyString() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)jsonMapper.readValue("\"2011-10-01/2011-10-10,2011-11-01/2011-11-10\"", QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof LegacySegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)new Interval((Object)"2011-10-01/2011-10-10"), (Object)new Interval((Object)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
    }

    @Test
    public void testSerializationLegacyArray() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)jsonMapper.readValue("[\"2011-09-01/2011-10-10\", \"2011-11-01/2011-11-10\"]", QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof LegacySegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)new Interval((Object)"2011-09-01/2011-10-10"), (Object)new Interval((Object)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
    }

    @Test
    public void testSerializationIntervals() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)jsonMapper.readValue("{\"type\": \"intervals\", \"intervals\":[\"2011-08-01/2011-10-10\", \"2011-11-01/2011-11-10\"]}", QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof MultipleIntervalSegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)new Interval((Object)"2011-08-01/2011-10-10"), (Object)new Interval((Object)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
    }

    @Test
    public void testSerializationSegments() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)jsonMapper.convertValue((Object)ImmutableMap.of((Object)"type", (Object)"segments", (Object)"segments", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"itvl", (Object)"2011-07-01/2011-10-10", (Object)"ver", (Object)"1", (Object)"part", (Object)0), (Object)ImmutableMap.of((Object)"itvl", (Object)"2011-07-01/2011-10-10", (Object)"ver", (Object)"1", (Object)"part", (Object)1), (Object)ImmutableMap.of((Object)"itvl", (Object)"2011-11-01/2011-11-10", (Object)"ver", (Object)"2", (Object)"part", (Object)10))), QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof MultipleSpecificSegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)new Interval((Object)"2011-07-01/2011-10-10"), (Object)new Interval((Object)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
        Assert.assertEquals((Object)ImmutableList.of((Object)new SegmentDescriptor(new Interval((Object)"2011-07-01/2011-10-10"), "1", 0), (Object)new SegmentDescriptor(new Interval((Object)"2011-07-01/2011-10-10"), "1", 1), (Object)new SegmentDescriptor(new Interval((Object)"2011-11-01/2011-11-10"), "2", 10)), (Object)((MultipleSpecificSegmentSpec)spec).getDescriptors());
    }
}

