/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectQueryEngine;
import io.druid.query.select.SelectQueryQueryToolChest;
import io.druid.query.select.SelectQueryRunnerFactory;
import io.druid.query.select.SelectResultValue;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SelectQueryRunnerTest {
    private static final String providerLowercase = "market";
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(QueryRunnerTestHelper.makeQueryRunners(new SelectQueryRunnerFactory(new SelectQueryQueryToolChest((ObjectMapper)new DefaultObjectMapper(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new SelectQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
    }

    public SelectQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Test
    public void testFullOnSelect() {
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), QueryRunnerTestHelper.fullOnInterval, null, QueryRunnerTestHelper.allGran, (List)Lists.newArrayList(), (List)Lists.newArrayList(), new PagingSpec(null, 3), null);
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, context), (List)Lists.newArrayList());
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)2), Arrays.asList(new EventHolder("testSegment", 0, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)providerLowercase, (Object)"spot").put((Object)"quality", (Object)"automotive").put((Object)"placement", (Object)"preferred").put((Object)"placementish", (Object)Lists.newArrayList((Object[])new String[]{"a", "preferred"})).put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)providerLowercase, (Object)"spot").put((Object)"quality", (Object)"business").put((Object)"placement", (Object)"preferred").put((Object)"placementish", (Object)Lists.newArrayList((Object[])new String[]{"b", "preferred"})).put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)providerLowercase, (Object)"spot").put((Object)"quality", (Object)"entertainment").put((Object)"placement", (Object)"preferred").put((Object)"placementish", (Object)Lists.newArrayList((Object[])new String[]{"e", "preferred"})).put((Object)"index", (Object)Float.valueOf(100.0f)).build())))));
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithDimsAndMets() {
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), QueryRunnerTestHelper.fullOnInterval, null, QueryRunnerTestHelper.allGran, (List)Lists.newArrayList((Object[])new String[]{providerLowercase}), (List)Lists.newArrayList((Object[])new String[]{"index"}), new PagingSpec(null, 3), null);
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, context), (List)Lists.newArrayList());
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)2), Arrays.asList(new EventHolder("testSegment", 0, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)providerLowercase, (Object)"spot").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)providerLowercase, (Object)"spot").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)providerLowercase, (Object)"spot").put((Object)"index", (Object)Float.valueOf(100.0f)).build())))));
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectPagination() {
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), QueryRunnerTestHelper.fullOnInterval, null, QueryRunnerTestHelper.allGran, (List)Lists.newArrayList((Object[])new String[]{"quality"}), (List)Lists.newArrayList((Object[])new String[]{"index"}), new PagingSpec(Maps.newLinkedHashMap((Map)ImmutableMap.of((Object)"testSegment", (Object)3)), 3), null);
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, context), (List)Lists.newArrayList());
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)5), Arrays.asList(new EventHolder("testSegment", 3, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)"quality", (Object)"health").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 4, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)"quality", (Object)"mezzanine").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 5, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)"quality", (Object)"news").put((Object)"index", (Object)Float.valueOf(100.0f)).build())))));
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullOnSelectWithFilter() {
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)new Interval((Object)"2011-01-12/2011-01-14")), (DimFilter)new SelectorDimFilter(providerLowercase, "spot"), QueryRunnerTestHelper.dayGran, (List)Lists.newArrayList((Object[])new String[]{"quality"}), (List)Lists.newArrayList((Object[])new String[]{"index"}), new PagingSpec(Maps.newLinkedHashMap((Map)ImmutableMap.of((Object)"testSegment", (Object)3)), 3), null);
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, context), (List)Lists.newArrayList());
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)5), Arrays.asList(new EventHolder("testSegment", 3, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)"quality", (Object)"health").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 4, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)"quality", (Object)"mezzanine").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 5, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")).put((Object)"quality", (Object)"news").put((Object)"index", (Object)Float.valueOf(100.0f)).build())))), new Result(new DateTime((Object)"2011-01-13T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)5), Arrays.asList(new EventHolder("testSegment", 3, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-13T00:00:00.000Z")).put((Object)"quality", (Object)"health").put((Object)"index", (Object)Float.valueOf(114.9474f)).build()), new EventHolder("testSegment", 4, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-13T00:00:00.000Z")).put((Object)"quality", (Object)"mezzanine").put((Object)"index", (Object)Float.valueOf(104.46577f)).build()), new EventHolder("testSegment", 5, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)new DateTime((Object)"2011-01-13T00:00:00.000Z")).put((Object)"quality", (Object)"news").put((Object)"index", (Object)Float.valueOf(102.851685f)).build())))));
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullSelectNoResults() {
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)new Interval((Object)"2011-01-12/2011-01-14")), (DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter(providerLowercase, "spot"), new SelectorDimFilter(providerLowercase, "foo"))), QueryRunnerTestHelper.allGran, (List)Lists.newArrayList(), (List)Lists.newArrayList(), new PagingSpec(null, 3), null);
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of(), (List)Lists.newArrayList())));
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullSelectNoDimensionAndMetric() {
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)new Interval((Object)"2011-01-12/2011-01-14")), null, QueryRunnerTestHelper.allGran, (List)Lists.newArrayList((Object[])new String[]{"foo"}), (List)Lists.newArrayList((Object[])new String[]{"foo2"}), new PagingSpec(null, 3), null);
        List results = Sequences.toList((Sequence)this.runner.run((Query)query, (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        HashMap res = Maps.newHashMap();
        res.put("timestamp", new DateTime((Object)"2011-01-12T00:00:00.000Z"));
        res.put("foo", null);
        res.put("foo2", null);
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)2), Arrays.asList(new EventHolder("testSegment", 0, (Map)res), new EventHolder("testSegment", 1, (Map)res), new EventHolder("testSegment", 2, (Map)res)))));
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    private static void verify(Iterable<Result<SelectResultValue>> expectedResults, Iterable<Result<SelectResultValue>> actualResults) {
        Iterator<Result<SelectResultValue>> expectedIter = expectedResults.iterator();
        Iterator<Result<SelectResultValue>> actualIter = actualResults.iterator();
        while (expectedIter.hasNext()) {
            Result<SelectResultValue> expected = expectedIter.next();
            Result<SelectResultValue> actual = actualIter.next();
            Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
            for (Map.Entry entry : ((SelectResultValue)expected.getValue()).getPagingIdentifiers().entrySet()) {
                Assert.assertEquals(entry.getValue(), ((SelectResultValue)actual.getValue()).getPagingIdentifiers().get(entry.getKey()));
            }
            Iterator expectedEvts = ((SelectResultValue)expected.getValue()).getEvents().iterator();
            Iterator actualEvts = ((SelectResultValue)actual.getValue()).getEvents().iterator();
            while (expectedEvts.hasNext()) {
                EventHolder exHolder = (EventHolder)expectedEvts.next();
                EventHolder acHolder = (EventHolder)actualEvts.next();
                Assert.assertEquals((Object)exHolder.getTimestamp(), (Object)acHolder.getTimestamp());
                Assert.assertEquals((long)exHolder.getOffset(), (long)acHolder.getOffset());
                for (Map.Entry ex : exHolder.getEvent().entrySet()) {
                    Object actVal = acHolder.getEvent().get(ex.getKey());
                    if (acHolder.getEvent().get(ex.getKey()) instanceof Double) {
                        actVal = Float.valueOf(((Double)actVal).floatValue());
                    }
                    Assert.assertEquals(ex.getValue(), actVal);
                }
            }
            if (!actualEvts.hasNext()) continue;
            throw new ISE("This event iterator should be exhausted!", new Object[0]);
        }
        if (actualIter.hasNext()) {
            throw new ISE("This iterator should be exhausted!", new Object[0]);
        }
    }
}

