/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectBinaryFn;
import io.druid.query.select.SelectResultValue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.junit.Test;

public class SelectBinaryFnTest {
    private static final String segmentId1 = "testSegment";
    private static final String segmentId2 = "testSegment";

    @Test
    public void testApply() throws Exception {
        SelectBinaryFn binaryFn = new SelectBinaryFn(QueryGranularity.ALL, new PagingSpec(null, 5));
        Result res1 = new Result(new DateTime((Object)"2013-01-01"), (Object)new SelectResultValue((Map)ImmutableMap.of(), Arrays.asList(new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T00"), (Object)"dim", (Object)"first")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T03"), (Object)"dim", (Object)"fourth")), new EventHolder("testSegment", 2, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T05"), (Object)"dim", (Object)"sixth")))));
        Result res2 = new Result(new DateTime((Object)"2013-01-01"), (Object)new SelectResultValue((Map)ImmutableMap.of(), Arrays.asList(new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T00"), (Object)"dim", (Object)"second")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T02"), (Object)"dim", (Object)"third")), new EventHolder("testSegment", 2, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T04"), (Object)"dim", (Object)"fifth")))));
        Result merged = binaryFn.apply(res1, res2);
        Assert.assertEquals((Object)res1.getTimestamp(), (Object)merged.getTimestamp());
        LinkedHashMap expectedPageIds = Maps.newLinkedHashMap();
        expectedPageIds.put("testSegment", 0);
        expectedPageIds.put("testSegment", 0);
        expectedPageIds.put("testSegment", 1);
        expectedPageIds.put("testSegment", 1);
        expectedPageIds.put("testSegment", 2);
        Iterator exSegmentIter = expectedPageIds.keySet().iterator();
        Iterator acSegmentIter = ((SelectResultValue)merged.getValue()).getPagingIdentifiers().keySet().iterator();
        this.verifyIters(exSegmentIter, acSegmentIter);
        Iterator exOffsetIter = expectedPageIds.values().iterator();
        Iterator acOffsetIter = ((SelectResultValue)merged.getValue()).getPagingIdentifiers().values().iterator();
        this.verifyIters(exOffsetIter, acOffsetIter);
        List<EventHolder> exEvents = Arrays.asList(new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T00"), (Object)"dim", (Object)"first")), new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T00"), (Object)"dim", (Object)"second")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T02"), (Object)"dim", (Object)"third")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T03"), (Object)"dim", (Object)"fourth")), new EventHolder("testSegment", 2, (Map)ImmutableMap.of((Object)"timestamp", (Object)new DateTime((Object)"2013-01-01T04"), (Object)"dim", (Object)"fifth")));
        List acEvents = ((SelectResultValue)merged.getValue()).getEvents();
        this.verifyEvents(exEvents, acEvents);
    }

    private void verifyIters(Iterator iter1, Iterator iter2) {
        while (iter1.hasNext()) {
            Assert.assertEquals(iter1.next(), iter2.next());
        }
        if (iter2.hasNext()) {
            throw new ISE("This should be empty!", new Object[0]);
        }
    }

    private void verifyEvents(List<EventHolder> events1, List<EventHolder> events2) {
        Iterator<EventHolder> ex = events1.iterator();
        Iterator<EventHolder> ac = events2.iterator();
        this.verifyIters(ex, ac);
    }
}

