/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Druids;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.ListColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import io.druid.segment.TestIndex;
import io.druid.segment.column.ValueType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataQueryTest {
    private final SegmentMetadataQueryRunnerFactory factory = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private final QueryRunner runner = SegmentMetadataQueryTest.makeQueryRunner((QueryRunnerFactory)this.factory);
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final SegmentMetadataQuery testQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals("2013/2014").toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList("placement"))).merge(true).build();
    private final SegmentAnalysis expectedSegmentAnalysis = new SegmentAnalysis("testSegment", (List)ImmutableList.of((Object)new Interval((Object)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")), (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), 10881L, Integer.valueOf(1), null)), 71982L);

    public static QueryRunner makeQueryRunner(QueryRunnerFactory factory) {
        return QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment("testSegment", TestIndex.getMMappedTestIndex()));
    }

    @Test
    public void testSegmentMetadataQuery() {
        List results = Sequences.toList((Sequence)this.runner.run((Query)this.testQuery, (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        Assert.assertEquals(Arrays.asList(this.expectedSegmentAnalysis), (Object)results);
    }

    @Test
    public void testBySegmentResults() {
        Result bySegmentResult = new Result(((Interval)this.expectedSegmentAnalysis.getIntervals().get(0)).getStart(), (Object)new BySegmentResultValueClass(Arrays.asList(this.expectedSegmentAnalysis), this.expectedSegmentAnalysis.getId(), (Interval)this.testQuery.getIntervals().get(0)));
        QueryToolChest toolChest = this.factory.getToolchest();
        QueryRunner singleSegmentQueryRunner = toolChest.preMergeQueryDecoration(this.runner);
        ExecutorService exec = Executors.newCachedThreadPool();
        FinalizeResultsQueryRunner myRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)Lists.newArrayList((Object[])new QueryRunner[]{singleSegmentQueryRunner, singleSegmentQueryRunner}))), toolChest);
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)bySegmentResult, (Object)bySegmentResult), myRunner.run(this.testQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true)), (Map)Maps.newHashMap()), "failed SegmentMetadata bySegment query");
        exec.shutdownNow();
    }

    @Test
    public void testSerde() throws Exception {
        String queryStr = "{\n  \"queryType\":\"segmentMetadata\",\n  \"dataSource\":\"test_ds\",\n  \"intervals\":[\"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z\"]\n}";
        Query query = (Query)this.mapper.readValue(queryStr, Query.class);
        Assert.assertTrue((boolean)(query instanceof SegmentMetadataQuery));
        Assert.assertEquals((Object)"test_ds", (Object)Iterables.getOnlyElement((Iterable)query.getDataSource().getNames()));
        Assert.assertEquals((Object)new Interval((Object)"2013-12-04T00:00:00.000Z/2013-12-05T00:00:00.000Z"), query.getIntervals().get(0));
        Assert.assertEquals((Object)query, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)query), Query.class));
    }
}

