/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.groupby.GroupByQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class GroupByQueryRunnerTestHelper {
    public static Iterable<Row> runQuery(QueryRunnerFactory factory, QueryRunner runner, GroupByQuery query) {
        QueryToolChest toolChest = factory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(toolChest.preMergeQueryDecoration(runner)), toolChest);
        Sequence queryResult = theRunner.run((Query)query, (Map)Maps.newHashMap());
        return Sequences.toList((Sequence)queryResult, (List)Lists.newArrayList());
    }

    public static Row createExpectedRow(String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)timestamp), vals);
    }

    public static Row createExpectedRow(DateTime timestamp, Object ... vals) {
        Preconditions.checkArgument((vals.length % 2 == 0 ? 1 : 0) != 0);
        HashMap theVals = Maps.newHashMap();
        for (int i = 0; i < vals.length; i += 2) {
            theVals.put(vals[i].toString(), vals[i + 1]);
        }
        DateTime ts = new DateTime((Object)timestamp);
        return new MapBasedRow(ts, (Map)theVals);
    }
}

