/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.granularity.PeriodGranularity;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.LookupExtractionFn;
import io.druid.query.extraction.LookupExtractor;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.query.extraction.TimeFormatExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.JavaScriptDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import io.druid.query.groupby.having.EqualToHavingSpec;
import io.druid.query.groupby.having.GreaterThanHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.having.OrHavingSpec;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryRunnerTest {
    private final QueryRunner<Row> runner;
    private GroupByQueryRunnerFactory factory;
    private Supplier<GroupByQueryConfig> configSupplier;

    @Before
    public void setUp() throws Exception {
        this.configSupplier = Suppliers.ofInstance((Object)new GroupByQueryConfig());
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        StupidPool pool = new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0x100000);
            }
        });
        GroupByQueryConfig config = new GroupByQueryConfig();
        config.setMaxIntermediateRows(10000);
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByQueryEngine engine = new GroupByQueryEngine(configSupplier, pool);
        final GroupByQueryRunnerFactory factory = new GroupByQueryRunnerFactory(engine, QueryRunnerTestHelper.NOOP_QUERYWATCHER, configSupplier, new GroupByQueryQueryToolChest(configSupplier, (ObjectMapper)mapper, engine, TestQueryRunners.pool, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), TestQueryRunners.pool);
        GroupByQueryConfig singleThreadedConfig = new GroupByQueryConfig(){

            public boolean isSingleThreaded() {
                return true;
            }
        };
        singleThreadedConfig.setMaxIntermediateRows(10000);
        Supplier singleThreadedConfigSupplier = Suppliers.ofInstance((Object)singleThreadedConfig);
        GroupByQueryEngine singleThreadEngine = new GroupByQueryEngine(singleThreadedConfigSupplier, pool);
        GroupByQueryRunnerFactory singleThreadFactory = new GroupByQueryRunnerFactory(singleThreadEngine, QueryRunnerTestHelper.NOOP_QUERYWATCHER, singleThreadedConfigSupplier, new GroupByQueryQueryToolChest(singleThreadedConfigSupplier, (ObjectMapper)mapper, singleThreadEngine, pool, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), pool);
        Function<Object, Object> function = new Function<Object, Object>(){

            public Object apply(@Nullable Object input) {
                return new Object[]{factory, input};
            }
        };
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(QueryRunnerTestHelper.makeQueryRunners(factory), (Function)function), (Iterable)Iterables.transform(QueryRunnerTestHelper.makeQueryRunners(singleThreadFactory), (Function)function)));
    }

    public GroupByQueryRunnerTest(GroupByQueryRunnerFactory factory, QueryRunner runner) {
        this.factory = factory;
        this.runner = runner;
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithRebucketRename() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map), false, null, false), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRenameRetainMissingNonInjective() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map), true, null, false), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRenameRetainMissing() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map), true, null, true), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRenameAndMissingString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map), false, "MISSING", true), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRename() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map), false, null, true), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithUniques() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.qualityUniques)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "uniques", 9.019833517963864));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByWithUniquesAndPostAggWithSameName() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new HyperUniquesAggregatorFactory("quality_uniques", "quality_uniques"))).setPostAggregatorSpecs(Arrays.asList(new HyperUniqueFinalizingPostAggregator("quality_uniques", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "quality_uniques", 9.019833517963864));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithCardinality() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.qualityCardinality)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "cardinality", 9.019833517963864));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithNullProducingDimExtractionFn() {
        RegexDimExtractionFn nullExtractionFn = new RegexDimExtractionFn("(\\w{1})"){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("mezzanine") ? null : super.apply(dimValue);
            }
        };
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)nullExtractionFn, null)})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", null, "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "b", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "e", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "h", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "n", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "p", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "t", "rows", 2L, "idx", 197L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", null, "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "a", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "b", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "e", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "h", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "n", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "p", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "t", "rows", 2L, "idx", 223L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "");
    }

    @Test
    public void testGroupByWithEmptyStringProducingDimExtractionFn() {
        RegexDimExtractionFn emptyStringExtractionFn = new RegexDimExtractionFn("(\\w{1})"){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("mezzanine") ? "" : super.apply(dimValue);
            }
        };
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)emptyStringExtractionFn, null)})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "b", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "e", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "h", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "n", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "p", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "t", "rows", 2L, "idx", 197L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "a", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "b", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "e", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "h", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "n", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "p", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "t", "rows", 2L, "idx", 223L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "");
    }

    @Test
    public void testGroupByWithTimeZone() {
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setInterval("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1D"), null, tz)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testMergeResults() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery fullQuery = builder.build();
        GroupByQuery allGranQuery = builder.copy().setGranularity(QueryGranularity.ALL).build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                Query query1 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-02/2011-04-03")})));
                Query query2 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-03/2011-04-04")})));
                return Sequences.concat((Sequence[])new Sequence[]{GroupByQueryRunnerTest.this.runner.run(query1, responseContext), GroupByQueryRunnerTest.this.runner.run(query2, responseContext)});
            }
        });
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, this.runner.run((Query)fullQuery, (Map)context), "direct");
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run((Query)fullQuery, (Map)context), "merged");
        List<Row> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L));
        TestHelper.assertExpectedObjects(allGranExpectedResults, this.runner.run((Query)allGranQuery, (Map)context), "direct");
        TestHelper.assertExpectedObjects(allGranExpectedResults, mergedRunner.run((Query)allGranQuery, (Map)context), "merged");
    }

    @Test
    public void testMergeResultsWithLimit() {
        for (int limit = 1; limit < 20; ++limit) {
            this.doTestMergeResultsWithValidLimit(limit);
        }
    }

    private void doTestMergeResultsWithValidLimit(int limit) {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimit(Integer.valueOf(limit));
        GroupByQuery fullQuery = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)limit), mergeRunner.run((Query)fullQuery, (Map)context), String.format("limit: %d", limit));
    }

    @Test
    public void testMergeResultsAcrossMultipleDaysWithLimitAndOrderBy() {
        int limit = 14;
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryGranularity.DAY).setLimit(Integer.valueOf(14)).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING);
        GroupByQuery fullQuery = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)14), mergeRunner.run((Query)fullQuery, (Map)context), String.format("limit: %d", 14));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeResultsWithNegativeLimit() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimit(Integer.valueOf(-1));
        builder.build();
    }

    @Test
    public void testMergeResultsWithOrderBy() {
        LimitSpec[] orderBySpecs = new LimitSpec[]{new DefaultLimitSpec(OrderByColumnSpec.ascending((String[])new String[]{"idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.ascending((String[])new String[]{"rows", "idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.descending((String[])new String[]{"idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.descending((String[])new String[]{"rows", "idx"}), null)};
        final Comparator<Row> idxComparator = new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                return Float.compare(o1.getFloatMetric("idx"), o2.getFloatMetric("idx"));
            }
        };
        Comparator<Row> rowsIdxComparator = new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                int value = Float.compare(o1.getFloatMetric("rows"), o2.getFloatMetric("rows"));
                if (value != 0) {
                    return value;
                }
                return idxComparator.compare(o1, o2);
            }
        };
        List<Row> allResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Ordering.from((Comparator)idxComparator).sortedCopy(allResults), Ordering.from((Comparator)rowsIdxComparator).sortedCopy(allResults), Ordering.from((Comparator)idxComparator).reverse().sortedCopy(allResults), Ordering.from((Comparator)rowsIdxComparator).reverse().sortedCopy(allResults)});
        for (int i = 0; i < orderBySpecs.length; ++i) {
            this.doTestMergeResultsWithOrderBy(orderBySpecs[i], (List)expectedResults.get(i));
        }
    }

    private void doTestMergeResultsWithOrderBy(LimitSpec orderBySpec, List<Row> expectedResults) {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimitSpec(orderBySpec);
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                Query query1 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-02/2011-04-03")})));
                Query query2 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-03/2011-04-04")})));
                return Sequences.concat((Sequence[])new Sequence[]{GroupByQueryRunnerTest.this.runner.run(query1, responseContext), GroupByQueryRunnerTest.this.runner.run(query2, responseContext)});
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run((Query)fullQuery, (Map)context), "merged");
    }

    @Test
    public void testGroupByOrderLimit() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn("rows").addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run((Query)query, (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run((Query)builder.limit(5).build(), (Map)context), "limited");
    }

    @Test
    public void testGroupByWithOrderLimit2() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn("rows", "desc").addOrderByColumn("alias", "d").setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run((Query)query, (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run((Query)builder.limit(5).build(), (Map)context), "limited");
    }

    @Test
    public void testGroupByWithOrderLimit3() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("idx", "index"))).addOrderByColumn("idx", "desc").addOrderByColumn("alias", "d").setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4423.6533203125), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4418.61865234375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319.94403076171875), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 270.3977966308594), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243.65843200683594), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 222.20980834960938), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 218.7224884033203), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216.97836303710938), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 178.24917602539062));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run((Query)query, (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run((Query)builder.limit(5).build(), (Map)context), "limited");
    }

    @Test
    public void testGroupByWithSameCaseOrdering() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "marketalias"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "upfront", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "total_market", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "spot", "rows", 837L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithOrderLimit4() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "upfront", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "total_market", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "spot", "rows", 837L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Ignore
    @Test
    public void testLimitPerGrouping() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.dayGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.firstToThird).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("rows", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(2))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01T00:00:00.000Z", "market", "spot", "rows", 9L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02T00:00:00.000Z", "market", "spot", "rows", 9L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Iterator<Row> resultsIter = results.iterator();
        Iterator<Row> expectedResultsIter = expectedResults.iterator();
        Row next1 = resultsIter.next();
        Row expectedNext1 = expectedResultsIter.next();
        Assert.assertEquals((String)"order-limit", (Object)expectedNext1, (Object)next1);
        Row next2 = resultsIter.next();
        Row expectedNext2 = expectedResultsIter.next();
        Assert.assertNotEquals((String)"order-limit", (Object)expectedNext2, (Object)next2);
    }

    @Test
    public void testPostAggMergedHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "index", 4420L, "addRowsIndexConstant", 4427.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "index", 4416L, "addRowsIndexConstant", 4423.0));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("addRowsIndexConstant", (Number)1000L))));
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                Query query1 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-02/2011-04-03")})));
                Query query2 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-03/2011-04-04")})));
                return Sequences.concat((Sequence[])new Sequence[]{GroupByQueryRunnerTest.this.runner.run(query1, responseContext), GroupByQueryRunnerTest.this.runner.run(query2, responseContext)});
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run((Query)fullQuery, (Map)context), "merged");
    }

    @Test
    public void testGroupByWithOrderLimitHavingSpec() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-01-25/2011-01-28").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("index", "index"))).setGranularity(QueryGranularity.ALL).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("index", (Number)310L)).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("index", OrderByColumnSpec.Direction.ASCENDING)}), Integer.valueOf(5)));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "business", "rows", 3L, "index", 312.38165283203125), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "news", "rows", 3L, "index", 312.7834167480469), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "technology", "rows", 3L, "index", 324.6412353515625), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "travel", "rows", 3L, "index", 393.36322021484375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "health", "rows", 3L, "index", 511.2996826171875));
        GroupByQuery fullQuery = builder.build();
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testPostAggHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "index", 4420L, "addRowsIndexConstant", 4427.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "index", 4416L, "addRowsIndexConstant", 4423.0));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("addRowsIndexConstant", (Number)1000L))));
        GroupByQuery fullQuery = builder.build();
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "");
    }

    @Test
    public void testHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows", (Number)2L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "");
    }

    @Test
    public void testMergedHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows", (Number)2L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                Query query1 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-02/2011-04-03")})));
                Query query2 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-03/2011-04-04")})));
                return Sequences.concat((Sequence[])new Sequence[]{GroupByQueryRunnerTest.this.runner.run(query1, responseContext), GroupByQueryRunnerTest.this.runner.run(query2, responseContext)});
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run((Query)fullQuery, (Map)context), "merged");
    }

    @Test
    public void testMergedPostAggHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L, "rows_times_10", 20.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L, "rows_times_10", 60.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L, "rows_times_10", 60.0));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("rows_times_10", "*", Arrays.asList(new FieldAccessPostAggregator("rows", "rows"), new ConstantPostAggregator("const", (Number)10L))))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows_times_10", (Number)20L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                Query query1 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-02/2011-04-03")})));
                Query query2 = query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{new Interval((Object)"2011-04-03/2011-04-04")})));
                return Sequences.concat((Sequence[])new Sequence[]{GroupByQueryRunnerTest.this.runner.run(query1, responseContext), GroupByQueryRunnerTest.this.runner.run(query2, responseContext)});
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, this.factory.getToolchest().postMergeQueryDecoration(this.factory.getToolchest().mergeResults(this.factory.getToolchest().preMergeQueryDecoration(mergedRunner))).run((Query)fullQuery, (Map)context), "merged");
    }

    @Test
    public void testGroupByWithRegEx() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimFilter((DimFilter)new RegexDimFilter("quality", "auto.*")).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "rows", 2L));
        GroupByQueryEngine engine = new GroupByQueryEngine(this.configSupplier, new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0x100000);
            }
        }));
        QueryRunner mergeRunner = new GroupByQueryQueryToolChest(this.configSupplier, (ObjectMapper)new DefaultObjectMapper(), engine, TestQueryRunners.pool, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()).mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run((Query)query, (Map)context), "no-limit");
    }

    @Test
    public void testGroupByWithMetricColumnDisappears() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").addDimension("quality").addDimension("index").setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "automotive", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "business", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "entertainment", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "health", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "mezzanine", "rows", 6L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "news", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "premium", "rows", 6L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "technology", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index", null, "quality", "travel", "rows", 2L));
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, this.runner.run((Query)query, (Map)context), "normal");
        GroupByQueryEngine engine = new GroupByQueryEngine(this.configSupplier, new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0x100000);
            }
        }));
        QueryRunner mergeRunner = new GroupByQueryQueryToolChest(this.configSupplier, (ObjectMapper)new DefaultObjectMapper(), engine, TestQueryRunners.pool, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()).mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run((Query)query, (Map)context), "no-limit");
    }

    @Test
    public void testGroupByWithNonexistentDimension() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").addDimension("billy").addDimension("quality").setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "automotive", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "business", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "entertainment", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "health", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "mezzanine", "rows", 6L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "news", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "premium", "rows", 6L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "technology", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "travel", "rows", 2L));
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, this.runner.run((Query)query, (Map)context), "normal");
        GroupByQueryEngine engine = new GroupByQueryEngine(this.configSupplier, new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0x100000);
            }
        }));
        QueryRunner mergeRunner = new GroupByQueryQueryToolChest(this.configSupplier, (ObjectMapper)new DefaultObjectMapper(), engine, TestQueryRunners.pool, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()).mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run((Query)query, (Map)context), "no-limit");
    }

    @Test
    public void testIdenticalSubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }")).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testDifferentGroupingSubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "idx", 2900.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "idx", 2505.0));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testDifferentIntervalSubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.secondOnly).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "idx", 2505.0));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testEmptySubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.emptyInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertFalse((boolean)results.iterator().hasNext());
    }

    @Test
    public void testSubqueryWithPostAggregators() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }")).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx_subagg", "index"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx_post", 11135.0, "idx", 1135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx_post", 11118.0, "idx", 1118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx_post", 13870.0, "idx", 3870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx_post", 13900.0, "idx", 3900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx_post", 11147.0, "idx", 1147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx_post", 11112.0, "idx", 1112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx_post", 11166.0, "idx", 1166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx_post", 11113.0, "idx", 1113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx_post", 13447.0, "idx", 3447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx_post", 11114.0, "idx", 1114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx_post", 13505.0, "idx", 3505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx_post", 11097.0, "idx", 1097L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx_post", 11126.0, "idx", 1126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithPostAggregatorsAndHaving() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }")).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx_subagg", "index"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setHavingSpec(new HavingSpec(){

            public boolean eval(Row row) {
                return row.getFloatMetric("idx_subpostagg") < 3800.0f;
            }

            public byte[] getCacheKey() {
                return new byte[0];
            }
        }).addOrderByColumn("alias").setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx_post", 11135.0, "idx", 1135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx_post", 11118.0, "idx", 1118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx_post", 11147.0, "idx", 1147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx_post", 11112.0, "idx", 1112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx_post", 11166.0, "idx", 1166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx_post", 11113.0, "idx", 1113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx_post", 13447.0, "idx", 3447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx_post", 11114.0, "idx", 1114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx_post", 13505.0, "idx", 3505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx_post", 11097.0, "idx", 1097L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx_post", 11126.0, "idx", 1126L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithMultiColumnAggregators() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("market", "function(dim){ return true; }")).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("idx_subagg", "index"), new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "market"), "function(current, index, dim){return current + index + dim.length;}", "function(){return 0;}", "function(a,b){return a + b;}"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setHavingSpec(new HavingSpec(){

            public boolean eval(Row row) {
                return row.getFloatMetric("idx_subpostagg") < 3800.0f;
            }

            public byte[] getCacheKey() {
                return new byte[0];
            }
        }).addOrderByColumn("alias").setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"), new DoubleSumAggregatorFactory("js_outer_agg", "js_agg"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L, "js_outer_agg", 123.92274475097656), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L, "js_outer_agg", 82.62254333496094), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L, "js_outer_agg", 125.58358001708984), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L, "js_outer_agg", 124.13470458984375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L, "js_outer_agg", 162.74722290039062));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithHyperUniques() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new HyperUniquesAggregatorFactory("quality_uniques", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"), new HyperUniquesAggregatorFactory("uniq", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 282L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 230L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 324L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 233L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5317L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 235L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 5405L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 175L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 245L, "uniq", 1.0002442201269182));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithTimeColumn() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.jsCountIfTimeGreaterThan, QueryRunnerTestHelper.__timeLongSum)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "ntimestamps", 13.0, "sumtime", 33843139200000L));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByTimeExtraction() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).setPostAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity(QueryRunnerTestHelper.allGran).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot"), new SelectorDimFilter("market", "upfront")))).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Friday", "market", "spot", "index", 13219.574157714844, "rows", 117L, "addRowsIndexConstant", 13337.574157714844), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Monday", "market", "spot", "index", 13557.738830566406, "rows", 117L, "addRowsIndexConstant", 13675.738830566406), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Saturday", "market", "spot", "index", 13493.751281738281, "rows", 117L, "addRowsIndexConstant", 13611.751281738281), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Sunday", "market", "spot", "index", 13585.541015625, "rows", 117L, "addRowsIndexConstant", 13703.541015625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Thursday", "market", "spot", "index", 14279.127197265625, "rows", 126L, "addRowsIndexConstant", 14406.127197265625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Tuesday", "market", "spot", "index", 13199.471435546875, "rows", 117L, "addRowsIndexConstant", 13317.471435546875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Wednesday", "market", "spot", "index", 14271.368591308594, "rows", 126L, "addRowsIndexConstant", 14398.368591308594), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Friday", "market", "upfront", "index", 27297.8623046875, "rows", 26L, "addRowsIndexConstant", 27324.8623046875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Monday", "market", "upfront", "index", 27619.58447265625, "rows", 26L, "addRowsIndexConstant", 27646.58447265625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Saturday", "market", "upfront", "index", 27820.83154296875, "rows", 26L, "addRowsIndexConstant", 27847.83154296875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Sunday", "market", "upfront", "index", 24791.223876953125, "rows", 26L, "addRowsIndexConstant", 24818.223876953125), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Thursday", "market", "upfront", "index", 28562.748901367188, "rows", 28L, "addRowsIndexConstant", 28591.748901367188), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Tuesday", "market", "upfront", "index", 26968.280639648438, "rows", 26L, "addRowsIndexConstant", 26995.280639648438), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Wednesday", "market", "upfront", "index", 28985.5751953125, "rows", 28L, "addRowsIndexConstant", 29014.5751953125));
        Iterable<Row> results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testBySegmentResults() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L)), "testSegment", new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine")).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run((Query)fullQuery, (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResultsUnOptimizedDimextraction() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 6L, "idx", 4420L)), "testSegment", new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0")), false, null, false), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine")).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run((Query)fullQuery, (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResultsOptimizedDimextraction() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 6L, "idx", 4420L)), "testSegment", new Interval((Object)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0")), false, null, true), null)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((QueryGranularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine")).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run((Query)fullQuery, (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }
}

