/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction.extraction;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.LookupExtractionFn;
import io.druid.query.extraction.LookupExtractor;
import io.druid.query.extraction.MapLookupExtractor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LookupExtractionFnTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private final boolean retainMissing;
    private final String replaceMissing;
    private final boolean injective;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return Iterables.transform((Iterable)Sets.cartesianProduct((List)ImmutableList.of((Object)ImmutableSet.of((Object)true, (Object)false), (Object)ImmutableSet.of((Object)"", (Object)"MISSING VALUE"), (Object)ImmutableSet.of((Object)true, (Object)false))), (Function)new Function<List<?>, Object[]>(){

            @Nullable
            public Object[] apply(List<?> input) {
                return input.toArray();
            }
        });
    }

    public LookupExtractionFnTest(boolean retainMissing, String replaceMissing, boolean injective) {
        this.replaceMissing = Strings.emptyToNull((String)replaceMissing);
        this.retainMissing = retainMissing;
        this.injective = injective;
    }

    @BeforeClass
    public static void setUpStatic() {
        OBJECT_MAPPER.registerSubtypes(new Class[]{LookupExtractionFn.class});
    }

    @Test
    public void testSimpleSerDe() throws IOException {
        if (this.retainMissing && !Strings.isNullOrEmpty((String)this.replaceMissing)) {
            return;
        }
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar")), this.retainMissing, this.replaceMissing, this.injective);
        String str1 = OBJECT_MAPPER.writeValueAsString((Object)lookupExtractionFn);
        LookupExtractionFn lookupExtractionFn2 = (LookupExtractionFn)OBJECT_MAPPER.readValue(str1, LookupExtractionFn.class);
        Assert.assertEquals((Object)this.retainMissing, (Object)lookupExtractionFn2.isRetainMissingValue());
        Assert.assertEquals((Object)this.replaceMissing, (Object)lookupExtractionFn2.getReplaceMissingValueWith());
        Assert.assertEquals((Object)this.injective, (Object)lookupExtractionFn2.isInjective());
        Assert.assertArrayEquals((byte[])lookupExtractionFn.getCacheKey(), (byte[])lookupExtractionFn2.getCacheKey());
        Assert.assertEquals((Object)str1, (Object)OBJECT_MAPPER.writeValueAsString((Object)lookupExtractionFn2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArgs() {
        if (!this.retainMissing || Strings.isNullOrEmpty((String)this.replaceMissing)) {
            throw new IAE("Case not valid", new Object[0]);
        }
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar")), this.retainMissing, Strings.emptyToNull((String)this.replaceMissing), this.injective);
    }

    @Test
    public void testCacheKey() {
        if (this.retainMissing && !Strings.isNullOrEmpty((String)this.replaceMissing)) {
            return;
        }
        HashMap weirdMap = Maps.newHashMap();
        weirdMap.put("foobar", null);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar")), this.retainMissing, this.replaceMissing, this.injective);
        if (Strings.isNullOrEmpty((String)this.replaceMissing) || this.retainMissing) {
            Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), !lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), lookupExtractionFn.isInjective()).getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), !lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), !lookupExtractionFn.isInjective()).getCacheKey()));
        }
        Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)weirdMap), lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), lookupExtractionFn.isInjective()).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(lookupExtractionFn.getCacheKey(), new LookupExtractionFn(lookupExtractionFn.getLookup(), lookupExtractionFn.isRetainMissingValue(), lookupExtractionFn.getReplaceMissingValueWith(), !lookupExtractionFn.isInjective()).getCacheKey()));
    }
}

