/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction.extraction;

import com.google.common.collect.ImmutableMap;
import io.druid.query.extraction.LookupExtractionFn;
import io.druid.query.extraction.LookupExtractor;
import io.druid.query.extraction.MapLookupExtractor;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LookupExtractionFnExpectationsTest {
    @Test
    public void testMissingKeyIsNull() {
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar")), true, null, false);
        Assert.assertNull((Object)lookupExtractionFn.apply(null));
    }

    @Test
    public void testMissingKeyIsReplaced() {
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar")), false, "REPLACE", false);
        Assert.assertEquals((Object)"REPLACE", (Object)lookupExtractionFn.apply(null));
    }

    @Test
    public void testNullKeyIsMappable() {
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"", (Object)"bar")), false, "REPLACE", false);
        Assert.assertEquals((Object)"bar", (Object)lookupExtractionFn.apply(null));
    }

    @Test
    public void testNullValue() {
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"")), false, "REPLACE", false);
        Assert.assertEquals((Object)"REPLACE", (Object)lookupExtractionFn.apply(null));
    }
}

