/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.TimeFormatExtractionFn;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class TimeFormatExtractionFnTest {
    private static final long[] timestamps = new long[]{new DateTime((Object)"2015-01-01T23:00:00Z").getMillis(), new DateTime((Object)"2015-01-02T23:00:00Z").getMillis(), new DateTime((Object)"2015-03-03T23:00:00Z").getMillis(), new DateTime((Object)"2015-03-04T23:00:00Z").getMillis(), new DateTime((Object)"2015-05-02T23:00:00Z").getMillis(), new DateTime((Object)"2015-12-21T23:00:00Z").getMillis()};

    @Test(expected=IllegalArgumentException.class)
    public void testIAEForNullPattern() throws Exception {
        new TimeFormatExtractionFn(null, null, null);
    }

    @Test
    public void testDayOfWeekExtraction() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("EEEE", null, null);
        Assert.assertEquals((Object)"Thursday", (Object)fn.apply(timestamps[0]));
        Assert.assertEquals((Object)"Friday", (Object)fn.apply(timestamps[1]));
        Assert.assertEquals((Object)"Tuesday", (Object)fn.apply(timestamps[2]));
        Assert.assertEquals((Object)"Wednesday", (Object)fn.apply(timestamps[3]));
        Assert.assertEquals((Object)"Saturday", (Object)fn.apply(timestamps[4]));
        Assert.assertEquals((Object)"Monday", (Object)fn.apply(timestamps[5]));
        this.testSerde(fn, "EEEE", null, null);
    }

    @Test
    public void testLocalizedExtraction() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("EEEE", null, "is");
        Assert.assertEquals((Object)"fimmtudagur", (Object)fn.apply(timestamps[0]));
        Assert.assertEquals((Object)"f\u00f6studagur", (Object)fn.apply(timestamps[1]));
        Assert.assertEquals((Object)"\u00feri\u00f0judagur", (Object)fn.apply(timestamps[2]));
        Assert.assertEquals((Object)"mi\u00f0vikudagur", (Object)fn.apply(timestamps[3]));
        Assert.assertEquals((Object)"laugardagur", (Object)fn.apply(timestamps[4]));
        Assert.assertEquals((Object)"m\u00e1nudagur", (Object)fn.apply(timestamps[5]));
        this.testSerde(fn, "EEEE", null, "is");
    }

    @Test
    public void testTimeZoneExtraction() throws Exception {
        TimeFormatExtractionFn fn = new TimeFormatExtractionFn("'In Berlin ist es schon 'EEEE", DateTimeZone.forID((String)"Europe/Berlin"), "de");
        Assert.assertEquals((Object)"In Berlin ist es schon Freitag", (Object)fn.apply(timestamps[0]));
        Assert.assertEquals((Object)"In Berlin ist es schon Samstag", (Object)fn.apply(timestamps[1]));
        Assert.assertEquals((Object)"In Berlin ist es schon Mittwoch", (Object)fn.apply(timestamps[2]));
        Assert.assertEquals((Object)"In Berlin ist es schon Donnerstag", (Object)fn.apply(timestamps[3]));
        Assert.assertEquals((Object)"In Berlin ist es schon Sonntag", (Object)fn.apply(timestamps[4]));
        Assert.assertEquals((Object)"In Berlin ist es schon Dienstag", (Object)fn.apply(timestamps[5]));
        this.testSerde(fn, "'In Berlin ist es schon 'EEEE", DateTimeZone.forID((String)"Europe/Berlin"), "de");
    }

    public void testSerde(TimeFormatExtractionFn fn, String format, DateTimeZone tz, String locale) throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = objectMapper.writeValueAsString((Object)fn);
        TimeFormatExtractionFn deserialized = (TimeFormatExtractionFn)objectMapper.readValue(json, TimeFormatExtractionFn.class);
        Assert.assertEquals((Object)format, (Object)deserialized.getFormat());
        Assert.assertEquals((Object)tz, (Object)deserialized.getTimeZone());
        Assert.assertEquals((Object)locale, (Object)deserialized.getLocale());
        Assert.assertEquals((Object)fn, (Object)deserialized);
    }

    @Test
    public void testSerdeFromJson() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"timeFormat\", \"format\" : \"HH\" }";
        TimeFormatExtractionFn extractionFn = (TimeFormatExtractionFn)objectMapper.readValue("{ \"type\" : \"timeFormat\", \"format\" : \"HH\" }", ExtractionFn.class);
        Assert.assertEquals((Object)"HH", (Object)extractionFn.getFormat());
        Assert.assertEquals(null, (Object)extractionFn.getLocale());
        Assert.assertEquals(null, (Object)extractionFn.getTimeZone());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

