/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.google.common.collect.Sets;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.RegexDimExtractionFn;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class RegexDimExtractionFnTest {
    private static final String[] paths = new String[]{"/druid/prod/historical", "/druid/prod/broker", "/druid/prod/coordinator", "/druid/demo/historical", "/druid/demo/broker", "/druid/demo/coordinator", "/dash/aloe", "/dash/baloo"};
    private static final String[] testStrings = new String[]{"apple", "awesome", "asylum", "business", "be", "cool"};

    @Test
    public void testPathExtraction() {
        String regex = "/([^/]+)/";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex);
        HashSet extracted = Sets.newHashSet();
        for (String path : paths) {
            extracted.add(extractionFn.apply(path));
        }
        Assert.assertEquals((long)2L, (long)extracted.size());
        Assert.assertTrue((boolean)extracted.contains("druid"));
        Assert.assertTrue((boolean)extracted.contains("dash"));
    }

    @Test
    public void testDeeperPathExtraction() {
        String regex = "^/([^/]+/[^/]+)(/|$)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex);
        HashSet extracted = Sets.newHashSet();
        for (String path : paths) {
            extracted.add(extractionFn.apply(path));
        }
        Assert.assertEquals((long)4L, (long)extracted.size());
        Assert.assertTrue((boolean)extracted.contains("druid/prod"));
        Assert.assertTrue((boolean)extracted.contains("druid/demo"));
        Assert.assertTrue((boolean)extracted.contains("dash/aloe"));
        Assert.assertTrue((boolean)extracted.contains("dash/baloo"));
    }

    @Test
    public void testStringExtraction() {
        String regex = "(.)";
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn(regex);
        HashSet extracted = Sets.newHashSet();
        for (String testString : testStrings) {
            extracted.add(extractionFn.apply(testString));
        }
        Assert.assertEquals((long)3L, (long)extracted.size());
        Assert.assertTrue((boolean)extracted.contains("a"));
        Assert.assertTrue((boolean)extracted.contains("b"));
        Assert.assertTrue((boolean)extracted.contains("c"));
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"regex\", \"expr\" : \".(...)?\" }";
        RegexDimExtractionFn extractionFn = (RegexDimExtractionFn)objectMapper.readValue("{ \"type\" : \"regex\", \"expr\" : \".(...)?\" }", ExtractionFn.class);
        Assert.assertEquals((Object)".(...)?", (Object)extractionFn.getExpr());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

