/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.google.common.collect.Sets;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.MatchingDimExtractionFn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MatchingDimExtractionFnTest {
    private static final String[] testStrings = new String[]{"Quito", "Calgary", "Tokyo", "Stockholm", "Vancouver", "Pretoria", "Wellington", null, "Ontario"};

    @Test
    public void testExtraction() {
        String regex = ".*[Tt][Oo].*";
        MatchingDimExtractionFn extractionFn = new MatchingDimExtractionFn(regex);
        List<String> expected = Arrays.asList("Quito", "Tokyo", "Stockholm", "Pretoria", "Wellington");
        HashSet extracted = Sets.newHashSet();
        for (String str : testStrings) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((long)5L, (long)extracted.size());
        for (String str : extracted) {
            Assert.assertTrue((boolean)expected.contains(str));
        }
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"partial\", \"expr\" : \".(...)?\" }";
        MatchingDimExtractionFn extractionFn = (MatchingDimExtractionFn)objectMapper.readValue("{ \"type\" : \"partial\", \"expr\" : \".(...)?\" }", ExtractionFn.class);
        Assert.assertEquals((Object)".(...)?", (Object)extractionFn.getExpr());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
    }
}

