/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.extraction.MatchingDimExtractionFn;
import io.druid.query.extraction.RegexDimExtractionFn;
import org.junit.Assert;
import org.junit.Test;

public class ExtractionDimensionSpecTest {
    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String oldJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        ExtractionDimensionSpec extractionDimensionSpec = (ExtractionDimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class);
        Assert.assertEquals((Object)"first3Letters", (Object)extractionDimensionSpec.getOutputName());
        Assert.assertEquals((Object)"myDim", (Object)extractionDimensionSpec.getDimension());
        Assert.assertNotNull((Object)extractionDimensionSpec.getExtractionFn());
        Assert.assertTrue((boolean)(extractionDimensionSpec.getExtractionFn() instanceof RegexDimExtractionFn));
        Assert.assertEquals((Object)extractionDimensionSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionDimensionSpec), DimensionSpec.class));
    }

    @Test
    public void testSerdeBackwardsCompatibility() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String oldJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        ExtractionDimensionSpec extractionDimensionSpec = (ExtractionDimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class);
        Assert.assertEquals((Object)"first3Letters", (Object)extractionDimensionSpec.getOutputName());
        Assert.assertEquals((Object)"myDim", (Object)extractionDimensionSpec.getDimension());
        Assert.assertNotNull((Object)extractionDimensionSpec.getExtractionFn());
        Assert.assertTrue((boolean)(extractionDimensionSpec.getExtractionFn() instanceof RegexDimExtractionFn));
        Assert.assertEquals((Object)extractionDimensionSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionDimensionSpec), DimensionSpec.class));
        String oldAndNewJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"partial\",\n        \"expr\": \"(...).*\"\n    },\n    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        Assert.assertTrue((boolean)(((DimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"partial\",\n        \"expr\": \"(...).*\"\n    },\n    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class)).getExtractionFn() instanceof MatchingDimExtractionFn));
    }
}

