/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.datasourcemetadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import io.druid.query.datasourcemetadata.DataSourceMetadataQueryRunnerFactory;
import io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import io.druid.query.datasourcemetadata.DataSourceQueryQueryToolChest;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import io.druid.timeline.LogicalSegment;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceMetadataQueryTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        DataSourceMetadataQuery query = Druids.newDataSourceMetadataQueryBuilder().dataSource("testing").build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testContextSerde() throws Exception {
        DataSourceMetadataQuery query = Druids.newDataSourceMetadataQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)1, (Object)"useCache", (Object)true, (Object)"populateCache", (Object)true, (Object)"finalize", (Object)true)).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query serdeQuery = (Query)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), Query.class)), Query.class);
        Assert.assertEquals((Object)1, (Object)serdeQuery.getContextValue("priority"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("useCache"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("populateCache"));
        Assert.assertEquals((Object)true, (Object)serdeQuery.getContextValue("finalize"));
    }

    @Test
    public void testMaxIngestedEventTime() throws Exception {
        OnheapIncrementalIndex rtIndex = new OnheapIncrementalIndex(0L, QueryGranularity.NONE, new AggregatorFactory[]{new CountAggregatorFactory("count")}, 1000);
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new DataSourceMetadataQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment((IncrementalIndex)rtIndex, "test"));
        DateTime timestamp = new DateTime(System.currentTimeMillis());
        rtIndex.add((InputRow)new MapBasedInputRow(timestamp.getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        DataSourceMetadataQuery dataSourceMetadataQuery = Druids.newDataSourceMetadataQueryBuilder().dataSource("testing").build();
        ConcurrentMap context = new MapMaker().makeMap();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        List results = Sequences.toList((Sequence)runner.run((Query)dataSourceMetadataQuery, (Map)context), (List)Lists.newArrayList());
        DataSourceMetadataResultValue val = (DataSourceMetadataResultValue)((Result)results.iterator().next()).getValue();
        DateTime maxIngestedEventTime = val.getMaxIngestedEventTime();
        Assert.assertEquals((Object)timestamp, (Object)maxIngestedEventTime);
    }

    @Test
    public void testFilterSegments() {
        List segments = new DataSourceQueryQueryToolChest().filterSegments(null, Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2012-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2012-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T01/PT1H");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T02/PT1H");
            }
        }));
        Assert.assertEquals((long)segments.size(), (long)2L);
        List<LogicalSegment> expected = Arrays.asList(new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01/P1D");
            }
        }, new LogicalSegment(){

            public Interval getInterval() {
                return new Interval((Object)"2013-01-01T02/PT1H");
            }
        });
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i).getInterval(), (Object)((LogicalSegment)segments.get(i)).getInterval());
        }
    }

    @Test
    public void testResultSerialization() {
        DataSourceMetadataResultValue resultValue = new DataSourceMetadataResultValue(new DateTime((Object)"2000-01-01T00Z"));
        Map resultValueMap = (Map)new DefaultObjectMapper().convertValue((Object)resultValue, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assert.assertEquals((Object)ImmutableMap.of((Object)"maxIngestedEventTime", (Object)"2000-01-01T00:00:00.000Z"), (Object)resultValueMap);
    }

    @Test
    public void testResultDeserialization() {
        ImmutableMap resultValueMap = ImmutableMap.of((Object)"maxIngestedEventTime", (Object)"2000-01-01T00:00:00.000Z");
        DataSourceMetadataResultValue resultValue = (DataSourceMetadataResultValue)new DefaultObjectMapper().convertValue((Object)resultValueMap, DataSourceMetadataResultValue.class);
        Assert.assertEquals((Object)new DateTime((Object)"2000"), (Object)resultValue.getMaxIngestedEventTime());
    }
}

