/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.AggregatorsModule;
import io.druid.query.aggregation.AggregationTestHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HyperUniquesAggregationTest {
    @Test
    public void testIngestAndQuery() throws Exception {
        AggregationTestHelper helper = new AggregationTestHelper(Lists.newArrayList((Object[])new AggregatorsModule[]{new AggregatorsModule()}));
        String metricSpec = "[{\"type\": \"hyperUnique\",\"name\": \"index_hll\",\"fieldName\": \"market\"}]";
        String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"quality\", \"placement\", \"placementish\", \"index\"]  }}";
        String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"index_hll\", \"fieldName\": \"index_hll\" }],\"postAggregations\": [  { \"type\": \"hyperUniqueCardinality\", \"name\": \"index_unique_count\", \"fieldName\": \"index_hll\" }],\"intervals\": [ \"1970/2050\" ]}";
        Sequence<Row> seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.sample.tsv").getFile()), parseSpec, metricSpec, 0L, QueryGranularity.NONE, 50000, query);
        MapBasedRow row = (MapBasedRow)((ArrayList)Sequences.toList(seq, (List)Lists.newArrayList())).get(0);
        Assert.assertEquals((double)3.0, (double)row.getFloatMetric("index_hll"), (double)0.1);
        Assert.assertEquals((double)3.0, (double)row.getFloatMetric("index_unique_count"), (double)0.1);
    }
}

