/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class HyperUniqueFinalizingPostAggregatorTest {
    private final HashFunction fn = Hashing.murmur3_128();

    @Test
    public void testCompute() throws Exception {
        Random random = new Random(0L);
        HyperUniqueFinalizingPostAggregator postAggregator = new HyperUniqueFinalizingPostAggregator("uniques", "uniques");
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (int i = 0; i < 100; ++i) {
            byte[] hashedVal = this.fn.hashLong(random.nextLong()).asBytes();
            collector.add(hashedVal);
        }
        double cardinality = (Double)postAggregator.compute((Map)ImmutableMap.of((Object)"uniques", (Object)collector));
        Assert.assertTrue((cardinality == 99.37233005831612 ? 1 : 0) != 0);
    }
}

