/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import io.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class CardinalityAggregatorTest {
    private static final List<String[]> values1 = CardinalityAggregatorTest.dimensionValues("a", "b", "c", "a", "a", null, "b", "b", "b", "b", "a", "a");
    private static final List<String[]> values2 = CardinalityAggregatorTest.dimensionValues("a", "b", "c", "x", "a", "e", "b", new String[]{null, "x"}, new String[]{"x", null}, new String[]{"y", "x"}, new String[]{"x", "y"}, new String[]{"x", "y", "a"});
    List<DimensionSelector> selectorList;
    CardinalityAggregatorFactory rowAggregatorFactory;
    CardinalityAggregatorFactory valueAggregatorFactory;
    final TestDimensionSelector dim1 = new TestDimensionSelector(values1);
    final TestDimensionSelector dim2 = new TestDimensionSelector(values2);

    private static List<String[]> dimensionValues(Object ... values) {
        return Lists.transform((List)Lists.newArrayList((Object[])values), (Function)new Function<Object, String[]>(){

            @Nullable
            public String[] apply(@Nullable Object input) {
                if (input instanceof String[]) {
                    return (String[])input;
                }
                return new String[]{(String)input};
            }
        });
    }

    private static void aggregate(List<DimensionSelector> selectorList, Aggregator agg) {
        agg.aggregate();
        for (DimensionSelector selector : selectorList) {
            ((TestDimensionSelector)selector).increment();
        }
    }

    private static void bufferAggregate(List<DimensionSelector> selectorList, BufferAggregator agg, ByteBuffer buf, int pos) {
        agg.aggregate(buf, pos);
        for (DimensionSelector selector : selectorList) {
            ((TestDimensionSelector)selector).increment();
        }
    }

    public CardinalityAggregatorTest() {
        this.selectorList = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim1, this.dim2});
        this.rowAggregatorFactory = new CardinalityAggregatorFactory("billy", (List)Lists.newArrayList((Object[])new String[]{"dim1", "dim2"}), true);
        this.valueAggregatorFactory = new CardinalityAggregatorFactory("billy", (List)Lists.newArrayList((Object[])new String[]{"dim1", "dim2"}), true);
    }

    @Test
    public void testAggregateRows() throws Exception {
        CardinalityAggregator agg = new CardinalityAggregator("billy", this.selectorList, true);
        for (int i = 0; i < values1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorList, (Aggregator)agg);
        }
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
    }

    @Test
    public void testAggregateValues() throws Exception {
        CardinalityAggregator agg = new CardinalityAggregator("billy", this.selectorList, false);
        for (int i = 0; i < values1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorList, (Aggregator)agg);
        }
        Assert.assertEquals((double)7.0, (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
    }

    @Test
    public void testBufferAggregateRows() throws Exception {
        CardinalityBufferAggregator agg = new CardinalityBufferAggregator(this.selectorList, true);
        int maxSize = this.rowAggregatorFactory.getMaxIntermediateSize();
        ByteBuffer buf = ByteBuffer.allocate(maxSize + 64);
        int pos = 10;
        buf.limit(pos + maxSize);
        agg.init(buf, pos);
        for (int i = 0; i < values1.size(); ++i) {
            CardinalityAggregatorTest.bufferAggregate(this.selectorList, (BufferAggregator)agg, buf, pos);
        }
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg.get(buf, pos))), (double)0.05);
    }

    @Test
    public void testBufferAggregateValues() throws Exception {
        CardinalityBufferAggregator agg = new CardinalityBufferAggregator(this.selectorList, false);
        int maxSize = this.valueAggregatorFactory.getMaxIntermediateSize();
        ByteBuffer buf = ByteBuffer.allocate(maxSize + 64);
        int pos = 10;
        buf.limit(pos + maxSize);
        agg.init(buf, pos);
        for (int i = 0; i < values1.size(); ++i) {
            CardinalityAggregatorTest.bufferAggregate(this.selectorList, (BufferAggregator)agg, buf, pos);
        }
        Assert.assertEquals((double)7.0, (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg.get(buf, pos))), (double)0.05);
    }

    @Test
    public void testCombineRows() {
        int i;
        ArrayList selector1 = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim1});
        ArrayList selector2 = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim2});
        CardinalityAggregator agg1 = new CardinalityAggregator("billy", (List)selector1, true);
        CardinalityAggregator agg2 = new CardinalityAggregator("billy", (List)selector2, true);
        for (i = 0; i < values1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector1, (Aggregator)agg1);
        }
        for (i = 0; i < values2.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector2, (Aggregator)agg2);
        }
        Assert.assertEquals((double)4.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg1.get())), (double)0.05);
        Assert.assertEquals((double)8.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(this.rowAggregatorFactory.combine(agg1.get(), agg2.get()))), (double)0.05);
    }

    @Test
    public void testCombineValues() {
        int i;
        ArrayList selector1 = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim1});
        ArrayList selector2 = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim2});
        CardinalityAggregator agg1 = new CardinalityAggregator("billy", (List)selector1, false);
        CardinalityAggregator agg2 = new CardinalityAggregator("billy", (List)selector2, false);
        for (i = 0; i < values1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector1, (Aggregator)agg1);
        }
        for (i = 0; i < values2.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector2, (Aggregator)agg2);
        }
        Assert.assertEquals((double)4.0, (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg1.get())), (double)0.05);
        Assert.assertEquals((double)7.0, (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
        Assert.assertEquals((double)7.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(this.rowAggregatorFactory.combine(agg1.get(), agg2.get()))), (double)0.05);
    }

    @Test
    public void testSerde() throws Exception {
        CardinalityAggregatorFactory factory = new CardinalityAggregatorFactory("billy", (List)ImmutableList.of((Object)"b", (Object)"a", (Object)"c"), true);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)factory, (Object)objectMapper.readValue(objectMapper.writeValueAsString((Object)factory), AggregatorFactory.class));
    }

    public static class TestDimensionSelector
    implements DimensionSelector {
        private final List<Integer[]> column;
        private final Map<String, Integer> ids;
        private final Map<Integer, String> lookup = Maps.newHashMap();
        private int pos = 0;

        public TestDimensionSelector(Iterable<String[]> values) {
            this.ids = Maps.newHashMap();
            int index = 0;
            for (String[] multiValue : values) {
                for (String value : multiValue) {
                    if (this.ids.containsKey(value)) continue;
                    this.ids.put(value, index);
                    this.lookup.put(index, value);
                    ++index;
                }
            }
            this.column = Lists.newArrayList((Iterable)Iterables.transform(values, (Function)new Function<String[], Integer[]>(){

                @Nullable
                public Integer[] apply(@Nullable String[] input) {
                    return (Integer[])Iterators.toArray((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])input), (Function)new Function<String, Integer>(){

                        @Nullable
                        public Integer apply(@Nullable String input) {
                            return (Integer)TestDimensionSelector.this.ids.get(input);
                        }
                    }), Integer.class);
                }
            }));
        }

        public void increment() {
            ++this.pos;
        }

        public void reset() {
            this.pos = 0;
        }

        public IndexedInts getRow() {
            final int p = this.pos;
            return new IndexedInts(){

                public int size() {
                    return ((Integer[])TestDimensionSelector.this.column.get(p)).length;
                }

                public int get(int i) {
                    return ((Integer[])TestDimensionSelector.this.column.get(p))[i];
                }

                public Iterator<Integer> iterator() {
                    return Iterators.forArray((Object[])((Object[])TestDimensionSelector.this.column.get(p)));
                }

                public void fill(int index, int[] toFill) {
                    throw new UnsupportedOperationException("fill not supported");
                }

                public void close() throws IOException {
                }
            };
        }

        public int getValueCardinality() {
            return 1;
        }

        public String lookupName(int i) {
            return this.lookup.get(i);
        }

        public int lookupId(String s) {
            return this.ids.get(s);
        }
    }
}

