/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.LongMinAggregator;
import io.druid.query.aggregation.LongMinAggregatorFactory;
import io.druid.query.aggregation.LongMinBufferAggregator;
import io.druid.query.aggregation.TestLongColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongMinAggregationTest {
    private LongMinAggregatorFactory longMinAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector selector;
    private long[] values = new long[]{-9223372036854775802L, -9223372036854775803L, -9223372036854775806L, -9223372036854775805L};

    public LongMinAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"longMin\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.longMinAggFactory = (LongMinAggregatorFactory)new DefaultObjectMapper().readValue(aggSpecJson, LongMinAggregatorFactory.class);
    }

    @Before
    public void setup() {
        this.selector = new TestLongColumnSelector(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeLongColumnSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongMinAggregator() {
        LongMinAggregator agg = (LongMinAggregator)this.longMinAggFactory.factorize(this.colSelectorFactory);
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get()));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
        agg.reset();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)agg.getLong());
    }

    @Test
    public void testLongMinBufferAggregator() {
        LongMinBufferAggregator agg = (LongMinBufferAggregator)this.longMinAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get(buffer, 0)));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((Object)-9223372036854775803L, (Object)this.longMinAggFactory.combine((Object)-9223372036854775800L, (Object)-9223372036854775803L));
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        LongMinAggregatorFactory one = new LongMinAggregatorFactory("name1", "fieldName1");
        LongMinAggregatorFactory oneMore = new LongMinAggregatorFactory("name1", "fieldName1");
        LongMinAggregatorFactory two = new LongMinAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestLongColumnSelector selector, LongMinAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestLongColumnSelector selector, LongMinBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

