/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.LongMaxAggregator;
import io.druid.query.aggregation.LongMaxAggregatorFactory;
import io.druid.query.aggregation.LongMaxBufferAggregator;
import io.druid.query.aggregation.TestLongColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongMaxAggregationTest {
    private LongMaxAggregatorFactory longMaxAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector selector;
    private long[] values = new long[]{0x7FFFFFFFFFFFFFFAL, 0x7FFFFFFFFFFFFFFBL, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL};

    public LongMaxAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"longMax\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.longMaxAggFactory = (LongMaxAggregatorFactory)new DefaultObjectMapper().readValue(aggSpecJson, LongMaxAggregatorFactory.class);
    }

    @Before
    public void setup() {
        this.selector = new TestLongColumnSelector(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeLongColumnSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongMaxAggregator() {
        LongMaxAggregator agg = (LongMaxAggregator)this.longMaxAggFactory.factorize(this.colSelectorFactory);
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get()));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
        agg.reset();
        Assert.assertEquals((long)Long.MIN_VALUE, (long)agg.getLong());
    }

    @Test
    public void testLongMaxBufferAggregator() {
        LongMaxBufferAggregator agg = (LongMaxBufferAggregator)this.longMaxAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((long)this.values[2], (long)((Long)agg.get(buffer, 0)));
        Assert.assertEquals((long)this.values[2], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((Object)0x7FFFFFFFFFFFFFFBL, (Object)this.longMaxAggFactory.combine((Object)0x7FFFFFFFFFFFFFF8L, (Object)0x7FFFFFFFFFFFFFFBL));
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        LongMaxAggregatorFactory one = new LongMaxAggregatorFactory("name1", "fieldName1");
        LongMaxAggregatorFactory oneMore = new LongMaxAggregatorFactory("name1", "fieldName1");
        LongMaxAggregatorFactory two = new LongMaxAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    private void aggregate(TestLongColumnSelector selector, LongMaxAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestLongColumnSelector selector, LongMaxBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

