/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.query.aggregation.JavaScriptAggregator;
import io.druid.query.aggregation.JavaScriptAggregatorBenchmark;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.JavaScriptBufferAggregator;
import io.druid.query.aggregation.MetricSelectorUtils;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.query.aggregation.TestObjectColumnSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JavaScriptAggregatorTest {
    protected static final Map<String, String> sumLogATimesBPlusTen = Maps.newHashMap();
    protected static final Map<String, String> scriptDoubleSum = Maps.newHashMap();

    private static void aggregate(TestFloatColumnSelector selector1, TestFloatColumnSelector selector2, Aggregator agg) {
        agg.aggregate();
        selector1.increment();
        selector2.increment();
    }

    private void aggregateBuffer(TestFloatColumnSelector selector1, TestFloatColumnSelector selector2, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        selector1.increment();
        selector2.increment();
    }

    private static void aggregate(TestFloatColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private static void aggregate(TestObjectColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        TestFloatColumnSelector selector1 = new TestFloatColumnSelector(new float[]{42.12f, 9.0f});
        TestFloatColumnSelector selector2 = new TestFloatColumnSelector(new float[]{2.0f, 3.0f});
        Map<String, String> script = sumLogATimesBPlusTen;
        JavaScriptAggregator agg = new JavaScriptAggregator("billy", Arrays.asList(MetricSelectorUtils.wrap(selector1), MetricSelectorUtils.wrap(selector2)), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        agg.reset();
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double val = 10.0;
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(selector1, selector2, (Aggregator)agg);
        Assert.assertEquals((Object)(val += Math.log(42.12f) * 2.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(selector1, selector2, (Aggregator)agg);
        Assert.assertEquals((Object)(val += Math.log(9.0) * 3.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
    }

    @Test
    public void testBufferAggregate() {
        TestFloatColumnSelector selector1 = new TestFloatColumnSelector(new float[]{42.12f, 9.0f});
        TestFloatColumnSelector selector2 = new TestFloatColumnSelector(new float[]{2.0f, 3.0f});
        Map<String, String> script = sumLogATimesBPlusTen;
        JavaScriptBufferAggregator agg = new JavaScriptBufferAggregator(Arrays.asList(MetricSelectorUtils.wrap(selector1), MetricSelectorUtils.wrap(selector2)), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        ByteBuffer buf = ByteBuffer.allocateDirect(32);
        int position = 4;
        agg.init(buf, 4);
        double val = 10.0;
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        this.aggregateBuffer(selector1, selector2, (BufferAggregator)agg, buf, 4);
        Assert.assertEquals((Object)(val += Math.log(42.12f) * 2.0), (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        this.aggregateBuffer(selector1, selector2, (BufferAggregator)agg, buf, 4);
        Assert.assertEquals((Object)(val += Math.log(9.0) * 3.0), (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
    }

    @Test
    public void testAggregateMissingColumn() {
        Map<String, String> script = scriptDoubleSum;
        JavaScriptAggregator agg = new JavaScriptAggregator("billy", Collections.singletonList(null), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        double val = 0.0;
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        agg.reset();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        agg.aggregate();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        agg.aggregate();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
    }

    @Test
    public void testAggregateStrings() {
        TestObjectColumnSelector ocs = new TestObjectColumnSelector("what", null, new String[]{"hey", "there"});
        JavaScriptAggregator agg = new JavaScriptAggregator("billy", Collections.singletonList(ocs), JavaScriptAggregatorFactory.compileScript((String)"function aggregate(current, a) { if (Array.isArray(a)) { return current + a.length; } else if (typeof a === 'string') { return current + 1; } else { return current; } }", (String)scriptDoubleSum.get("fnReset"), (String)scriptDoubleSum.get("fnCombine")));
        agg.reset();
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double val = 0.0;
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)(val += 1.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)(val += 2.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
    }

    public static void main(String ... args) throws Exception {
        int i;
        JavaScriptAggregatorBenchmark.LoopingFloatColumnSelector selector = new JavaScriptAggregatorBenchmark.LoopingFloatColumnSelector(new float[]{42.12f, 9.0f});
        Map<String, String> script = scriptDoubleSum;
        JavaScriptAggregator aggRhino = new JavaScriptAggregator("billy", Lists.asList(MetricSelectorUtils.wrap(selector), (Object[])new ObjectColumnSelector[0]), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        DoubleSumAggregator doubleAgg = new DoubleSumAggregator("billy", (FloatColumnSelector)selector);
        long t = 0L;
        for (i = 0; i < 10000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)aggRhino);
        }
        for (i = 0; i < 10000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)doubleAgg);
        }
        t = System.currentTimeMillis();
        for (i = 0; i < 500000000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)aggRhino);
        }
        long t1 = System.currentTimeMillis() - t;
        System.out.println(String.format("JavaScript aggregator == %,f: %d ms", aggRhino.get(), t1));
        t = System.currentTimeMillis();
        for (i = 0; i < 500000000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)doubleAgg);
        }
        long t2 = System.currentTimeMillis() - t;
        System.out.println(String.format("DoubleSum  aggregator == %,f: %d ms", doubleAgg.get(), t2));
        System.out.println(String.format("JavaScript is %2.1fx slower", (double)t1 / (double)t2));
    }

    static {
        sumLogATimesBPlusTen.put("fnAggregate", "function aggregate(current, a, b) { return current + (Math.log(a) * b) }");
        sumLogATimesBPlusTen.put("fnReset", "function reset()                  { return 10 }");
        sumLogATimesBPlusTen.put("fnCombine", "function combine(a,b)             { return a + b }");
        scriptDoubleSum.put("fnAggregate", "function aggregate(current, a) { return current + a }");
        scriptDoubleSum.put("fnReset", "function reset()               { return 0 }");
        scriptDoubleSum.put("fnCombine", "function combine(a,b)          { return a + b }");
    }
}

