/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.query.aggregation.JavaScriptAggregator;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.MetricSelectorUtils;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import java.util.Map;

public class JavaScriptAggregatorBenchmark
extends SimpleBenchmark {
    protected static final Map<String, String> scriptDoubleSum = Maps.newHashMap();
    private JavaScriptAggregator jsAggregator;
    private DoubleSumAggregator doubleAgg;
    final LoopingFloatColumnSelector selector = new LoopingFloatColumnSelector(new float[]{42.12f, 9.0f});

    private static void aggregate(TestFloatColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    protected void setUp() throws Exception {
        Map<String, String> script = scriptDoubleSum;
        this.jsAggregator = new JavaScriptAggregator("billy", Lists.asList(MetricSelectorUtils.wrap(this.selector), (Object[])new ObjectColumnSelector[0]), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        this.doubleAgg = new DoubleSumAggregator("billy", (FloatColumnSelector)this.selector);
    }

    public double timeJavaScriptDoubleSum(int reps) {
        double val = 0.0;
        for (int i = 0; i < reps; ++i) {
            JavaScriptAggregatorBenchmark.aggregate(this.selector, (Aggregator)this.jsAggregator);
        }
        return val;
    }

    public double timeNativeDoubleSum(int reps) {
        double val = 0.0;
        for (int i = 0; i < reps; ++i) {
            JavaScriptAggregatorBenchmark.aggregate(this.selector, (Aggregator)this.doubleAgg);
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        Runner.main(JavaScriptAggregatorBenchmark.class, (String[])args);
    }

    static {
        scriptDoubleSum.put("fnAggregate", "function aggregate(current, a) { return current + a }");
        scriptDoubleSum.put("fnReset", "function reset() { return 0 }");
        scriptDoubleSum.put("fnCombine", "function combine(a,b) { return a + b }");
    }

    protected static class LoopingFloatColumnSelector
    extends TestFloatColumnSelector {
        private final float[] floats;
        private long index = 0L;

        public LoopingFloatColumnSelector(float[] floats) {
            super(floats);
            this.floats = floats;
        }

        @Override
        public float get() {
            return this.floats[(int)(this.index % (long)this.floats.length)];
        }

        @Override
        public void increment() {
            ++this.index;
            if (this.index < 0L) {
                this.index = 0L;
            }
        }
    }
}

