/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Maps;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.Histogram;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class HistogramTest {
    @Test
    public void testOffer() {
        float[] values = new float[]{0.55f, 0.27f, -0.3f, -0.1f, -0.8f, -0.7f, -0.5f, 0.25f, 0.1f, 2.0f, -3.0f};
        float[] breaks = new float[]{-1.0f, -0.5f, 0.0f, 0.5f, 1.0f};
        Histogram hExpected = new Histogram(breaks, new long[]{1L, 3L, 2L, 3L, 1L, 1L}, -3.0f, 2.0f);
        Histogram h = new Histogram(breaks);
        for (float v : values) {
            h.offer(v);
        }
        Assert.assertEquals((String)"histogram matches expected histogram", (Object)hExpected, (Object)h);
    }

    @Test
    public void testToFromBytes() {
        float[] breaks = new float[]{-1.0f, -0.5f, 0.0f, 0.5f, 1.0f};
        long[] bins = new long[]{23L, 123L, 4L, 56L, 7L, 493210L};
        Histogram h = new Histogram(breaks, bins, -1.0f, 1.0f);
        Assert.assertEquals((Object)Histogram.fromBytes((byte[])h.toBytes()), (Object)h);
    }

    @Test
    public void testAsVisual() throws Exception {
        float[] breaks = new float[]{-1.0f, -0.5f, 0.0f, 0.5f, 1.0f};
        long[] bins = new long[]{23L, 123L, 4L, 56L, 7L, 493210L};
        Histogram h = new Histogram(breaks, bins, -1.0f, 1.0f);
        Double[] visualBreaks = new Double[]{-1.0, -0.5, 0.0, 0.5, 1.0};
        Double[] visualCounts = new Double[]{123.0, 4.0, 56.0, 7.0};
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = objectMapper.writeValueAsString((Object)h.asVisual());
        LinkedHashMap expectedObj = Maps.newLinkedHashMap();
        expectedObj.put("breaks", Arrays.asList(visualBreaks));
        expectedObj.put("counts", Arrays.asList(visualCounts));
        expectedObj.put("quantiles", Arrays.asList(-1.0, 1.0));
        Map obj = (Map)objectMapper.readValue(json, Object.class);
        Assert.assertEquals((Object)expectedObj, (Object)obj);
    }
}

