/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.Histogram;
import io.druid.query.aggregation.HistogramAggregator;
import io.druid.query.aggregation.HistogramAggregatorFactory;
import io.druid.query.aggregation.HistogramBufferAggregator;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.segment.FloatColumnSelector;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HistogramAggregatorTest {
    private void aggregate(TestFloatColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json0 = "{\"type\": \"histogram\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        HistogramAggregatorFactory agg0 = (HistogramAggregatorFactory)objectMapper.readValue(json0, HistogramAggregatorFactory.class);
        Assert.assertEquals((Object)ImmutableList.of(), (Object)agg0.getBreaks());
        String aggSpecJson = "{\"type\": \"histogram\", \"name\": \"billy\", \"fieldName\": \"nilly\", \"breaks\": [ -1, 2, 3.0 ]}";
        HistogramAggregatorFactory agg = (HistogramAggregatorFactory)objectMapper.readValue(aggSpecJson, HistogramAggregatorFactory.class);
        Assert.assertEquals((Object)new HistogramAggregatorFactory("billy", "nilly", Arrays.asList(Float.valueOf(-1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f))), (Object)agg);
        Assert.assertEquals((Object)agg, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)agg), HistogramAggregatorFactory.class));
    }

    @Test
    public void testAggregate() throws Exception {
        float[] values = new float[]{0.55f, 0.27f, -0.3f, -0.1f, -0.8f, -0.7f, -0.5f, 0.25f, 0.1f, 2.0f, -3.0f};
        float[] breaks = new float[]{-1.0f, -0.5f, 0.0f, 0.5f, 1.0f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        HistogramAggregator agg = new HistogramAggregator("billy", (FloatColumnSelector)selector, breaks);
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L}, (long[])((Histogram)agg.get()).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L}, (long[])((Histogram)agg.get()).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 1L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 2L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 2L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 3L, 1L, 0L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 3L, 1L, 1L}, (long[])((Histogram)agg.get()).bins);
        this.aggregate(selector, (Aggregator)agg);
        Assert.assertArrayEquals((long[])new long[]{1L, 3L, 2L, 3L, 1L, 1L}, (long[])((Histogram)agg.get()).bins);
    }

    private void aggregateBuffer(TestFloatColumnSelector selector, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        selector.increment();
    }

    @Test
    public void testBufferAggregate() throws Exception {
        float[] values = new float[]{0.55f, 0.27f, -0.3f, -0.1f, -0.8f, -0.7f, -0.5f, 0.25f, 0.1f, 2.0f, -3.0f};
        float[] breaks = new float[]{-1.0f, -0.5f, 0.0f, 0.5f, 1.0f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        ArrayList b = Lists.newArrayList();
        for (int i = 0; i < breaks.length; ++i) {
            b.add(Float.valueOf(breaks[i]));
        }
        HistogramAggregatorFactory factory = new HistogramAggregatorFactory("billy", "billy", (List)b);
        HistogramBufferAggregator agg = new HistogramBufferAggregator((FloatColumnSelector)selector, breaks);
        ByteBuffer buf = ByteBuffer.allocateDirect(factory.getMaxIntermediateSize());
        int position = 0;
        agg.init(buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 1L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 2L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 1L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 2L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 3L, 1L, 0L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{0L, 3L, 2L, 3L, 1L, 1L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
        this.aggregateBuffer(selector, (BufferAggregator)agg, buf, position);
        Assert.assertArrayEquals((long[])new long[]{1L, 3L, 2L, 3L, 1L, 1L}, (long[])((Histogram)agg.get((ByteBuffer)buf, (int)position)).bins);
    }
}

