/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.segment.FloatColumnSelector;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;

public class DoubleSumAggregatorTest {
    private void aggregate(TestFloatColumnSelector selector, DoubleSumAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        DoubleSumAggregator agg = new DoubleSumAggregator("billy", (FloatColumnSelector)selector);
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        this.aggregate(selector, agg);
        Assert.assertEquals((Object)expectedFirst, (Object)agg.get());
        Assert.assertEquals((Object)expectedFirst, (Object)agg.get());
        Assert.assertEquals((Object)expectedFirst, (Object)agg.get());
        this.aggregate(selector, agg);
        Assert.assertEquals((Object)expectedSecond, (Object)agg.get());
        Assert.assertEquals((Object)expectedSecond, (Object)agg.get());
        Assert.assertEquals((Object)expectedSecond, (Object)agg.get());
    }

    @Test
    public void testComparator() {
        TestFloatColumnSelector selector = new TestFloatColumnSelector(new float[]{0.15f, 0.27f});
        DoubleSumAggregator agg = new DoubleSumAggregator("billy", (FloatColumnSelector)selector);
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        Object first = agg.get();
        agg.aggregate();
        Comparator comp = new DoubleSumAggregatorFactory("null", "null").getComparator();
        Assert.assertEquals((long)-1L, (long)comp.compare(first, agg.get()));
        Assert.assertEquals((long)0L, (long)comp.compare(first, first));
        Assert.assertEquals((long)0L, (long)comp.compare(agg.get(), agg.get()));
        Assert.assertEquals((long)1L, (long)comp.compare(agg.get(), first));
    }
}

