/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.DoubleMaxAggregator;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMaxBufferAggregator;
import io.druid.query.aggregation.MaxAggregatorFactory;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleMaxAggregationTest {
    private DoubleMaxAggregatorFactory doubleMaxAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestFloatColumnSelector selector;
    private float[] values = new float[]{1.1f, 2.7f, 3.5f, 1.3f};

    public DoubleMaxAggregationTest() throws Exception {
        String aggSpecJson = "{\"type\": \"doubleMax\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        this.doubleMaxAggFactory = (DoubleMaxAggregatorFactory)new DefaultObjectMapper().readValue(aggSpecJson, DoubleMaxAggregatorFactory.class);
    }

    @Before
    public void setup() {
        this.selector = new TestFloatColumnSelector(this.values);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeFloatColumnSelector("nilly")).andReturn((Object)this.selector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleMaxAggregator() {
        DoubleMaxAggregator agg = (DoubleMaxAggregator)this.doubleMaxAggFactory.factorize(this.colSelectorFactory);
        Assert.assertEquals((Object)"billy", (Object)agg.getName());
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        this.aggregate(this.selector, agg);
        Assert.assertEquals((double)this.values[2], (double)((Double)agg.get()), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.values[2]), (long)agg.getLong());
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(), (double)1.0E-4);
        agg.reset();
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)((Double)agg.get()), (double)1.0E-4);
    }

    @Test
    public void testDoubleMaxBufferAggregator() {
        DoubleMaxBufferAggregator agg = (DoubleMaxBufferAggregator)this.doubleMaxAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        agg.init(buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        this.aggregate(this.selector, agg, buffer, 0);
        Assert.assertEquals((double)this.values[2], (double)((Double)agg.get(buffer, 0)), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.values[2]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.values[2], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        Assert.assertEquals((double)3.4, (double)((Double)this.doubleMaxAggFactory.combine((Object)1.2, (Object)3.4)), (double)1.0E-4);
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        DoubleMaxAggregatorFactory one = new DoubleMaxAggregatorFactory("name1", "fieldName1");
        DoubleMaxAggregatorFactory oneMore = new DoubleMaxAggregatorFactory("name1", "fieldName1");
        DoubleMaxAggregatorFactory two = new DoubleMaxAggregatorFactory("name2", "fieldName2");
        Assert.assertEquals((long)one.hashCode(), (long)oneMore.hashCode());
        Assert.assertTrue((boolean)one.equals((Object)oneMore));
        Assert.assertFalse((boolean)one.equals((Object)two));
    }

    @Test
    public void testMaxDeserialization() throws Exception {
        String aggSpecJson = "{\"type\": \"max\", \"name\": \"billy\", \"fieldName\": \"nilly\"}";
        MaxAggregatorFactory agg = (MaxAggregatorFactory)new DefaultObjectMapper().readValue(aggSpecJson, MaxAggregatorFactory.class);
        Assert.assertNotNull((Object)agg);
    }

    private void aggregate(TestFloatColumnSelector selector, DoubleMaxAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private void aggregate(TestFloatColumnSelector selector, DoubleMaxBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        selector.increment();
    }
}

