/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.ConcatQueryRunner;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulatorFns;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class AggregationTestHelper {
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final GroupByQueryQueryToolChest toolChest;
    private final GroupByQueryRunnerFactory factory;

    public AggregationTestHelper(List<? extends Module> jsonModulesToRegister) {
        for (Module module : jsonModulesToRegister) {
            this.mapper.registerModule(module);
        }
        Supplier configSupplier = Suppliers.ofInstance((Object)new GroupByQueryConfig());
        StupidPool stupidPool = new StupidPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(0x100000);
            }
        });
        QueryWatcher noopQueryWatcher = new QueryWatcher(){

            public void registerQuery(Query query, ListenableFuture future) {
            }
        };
        GroupByQueryEngine engine = new GroupByQueryEngine(configSupplier, stupidPool);
        this.toolChest = new GroupByQueryQueryToolChest(configSupplier, this.mapper, engine, stupidPool, AggregationTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        this.factory = new GroupByQueryRunnerFactory(engine, noopQueryWatcher, configSupplier, this.toolChest, stupidPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence<Row> createIndexAndRunQueryOnSegment(File inputDataFile, String parserJson, String aggregators, long minTimestamp, QueryGranularity gran, int maxRowCount, String groupByQueryJson) throws Exception {
        File segmentDir = Files.createTempDir();
        try {
            this.createIndex(inputDataFile, parserJson, aggregators, segmentDir, minTimestamp, gran, maxRowCount);
            Sequence<Row> sequence = this.runQueryOnSegments((List<File>)Lists.newArrayList((Object[])new File[]{segmentDir}), groupByQueryJson);
            return sequence;
        }
        finally {
            FileUtils.deleteDirectory((File)segmentDir);
        }
    }

    public void createIndex(File inputDataFile, String parserJson, String aggregators, File outDir, long minTimestamp, QueryGranularity gran, int maxRowCount) throws Exception {
        StringInputRowParser parser = (StringInputRowParser)this.mapper.readValue(parserJson, StringInputRowParser.class);
        LineIterator iter = FileUtils.lineIterator((File)inputDataFile, (String)"UTF-8");
        List aggregatorSpecs = (List)this.mapper.readValue(aggregators, (TypeReference)new TypeReference<List<AggregatorFactory>>(){});
        this.createIndex((Iterator)iter, (InputRowParser)parser, aggregatorSpecs.toArray(new AggregatorFactory[0]), outDir, minTimestamp, gran, true, maxRowCount);
    }

    public void createIndex(Iterator rows, InputRowParser parser, AggregatorFactory[] metrics, File outDir, long minTimestamp, QueryGranularity gran, boolean deserializeComplexMetrics, int maxRowCount) throws Exception {
        try (OnheapIncrementalIndex index = new OnheapIncrementalIndex(minTimestamp, gran, metrics, deserializeComplexMetrics, maxRowCount);){
            while (rows.hasNext()) {
                Object row = rows.next();
                if (row instanceof String && parser instanceof StringInputRowParser) {
                    index.add(((StringInputRowParser)parser).parse((String)row));
                    continue;
                }
                index.add(parser.parse(row));
            }
            IndexMerger.persist((IncrementalIndex)index, (File)outDir, (IndexSpec)new IndexSpec());
        }
    }

    public Sequence<Row> runQueryOnSegments(List<File> segmentDirs, String groupByQueryJson) throws Exception {
        return this.runQueryOnSegments(segmentDirs, (GroupByQuery)this.mapper.readValue(groupByQueryJson, GroupByQuery.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence<Row> runQueryOnSegments(List<File> segmentDirs, final GroupByQuery query) {
        List segments = Lists.transform(segmentDirs, (Function)new Function<File, QueryableIndexSegment>(){

            public QueryableIndexSegment apply(File segmentDir) {
                try {
                    return new QueryableIndexSegment("", IndexIO.loadIndex((File)segmentDir));
                }
                catch (IOException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        });
        try {
            FinalizeResultsQueryRunner baseRunner = new FinalizeResultsQueryRunner(this.toolChest.postMergeQueryDecoration(this.toolChest.mergeResults(this.toolChest.preMergeQueryDecoration((QueryRunner)new ConcatQueryRunner(Sequences.simple((Iterable)Lists.transform((List)segments, (Function)new Function<Segment, QueryRunner>(){

                public QueryRunner apply(Segment segment) {
                    try {
                        return AggregationTestHelper.this.makeStringSerdeQueryRunner(AggregationTestHelper.this.mapper, (QueryToolChest)AggregationTestHelper.this.toolChest, (Query<Row>)query, (QueryRunner<Row>)AggregationTestHelper.this.factory.createRunner(segment));
                    }
                    catch (Exception ex) {
                        throw Throwables.propagate((Throwable)ex);
                    }
                }
            })))))), (QueryToolChest)this.toolChest);
            Sequence sequence = baseRunner.run((Query)query, (Map)Maps.newHashMap());
            return sequence;
        }
        finally {
            for (Segment segment : segments) {
                CloseQuietly.close((Closeable)segment);
            }
        }
    }

    public QueryRunner<Row> makeStringSerdeQueryRunner(final ObjectMapper mapper, final QueryToolChest toolChest, Query<Row> query, final QueryRunner<Row> baseRunner) {
        return new QueryRunner<Row>(){

            public Sequence<Row> run(Query<Row> query, Map<String, Object> map) {
                try {
                    Sequence resultSeq = baseRunner.run(query, (Map)Maps.newHashMap());
                    Yielder yielder = resultSeq.toYielder(null, new YieldingAccumulator(){

                        public Object accumulate(Object accumulated, Object in) {
                            this.yield();
                            return in;
                        }
                    });
                    String resultStr = mapper.writer().writeValueAsString((Object)yielder);
                    List resultRows = Lists.transform((List)((List)mapper.readValue(resultStr, (TypeReference)new TypeReference<List<Row>>(){})), (Function)toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing()));
                    return Sequences.simple((Iterable)resultRows);
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        };
    }

    public static IntervalChunkingQueryRunnerDecorator NoopIntervalChunkingQueryRunnerDecorator() {
        return new IntervalChunkingQueryRunnerDecorator(null, null, null){

            public <T> QueryRunner<T> decorate(final QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> toolChest) {
                return new QueryRunner<T>(){

                    public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
                        return delegate.run(query, responseContext);
                    }
                };
            }
        };
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

