/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.TimewarpOperator;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class TimewarpOperatorTest {
    public static final ImmutableMap<String, Object> CONTEXT = ImmutableMap.of();
    TimewarpOperator<Result<TimeseriesResultValue>> testOperator = new TimewarpOperator(new Interval((ReadableInstant)new DateTime((Object)"2014-01-01"), (ReadableInstant)new DateTime((Object)"2014-01-15")), new Period((Object)"P1W"), new DateTime((Object)"2014-01-06"));

    @Test
    public void testComputeOffset() throws Exception {
        DateTime t = new DateTime((Object)"2014-01-23");
        DateTime tOffset = new DateTime((Object)"2014-01-09");
        Assert.assertEquals((Object)new DateTime((Object)tOffset), (Object)t.plus(this.testOperator.computeOffset(t.getMillis())));
        t = new DateTime((Object)"2014-08-02");
        tOffset = new DateTime((Object)"2014-01-11");
        Assert.assertEquals((Object)new DateTime((Object)tOffset), (Object)t.plus(this.testOperator.computeOffset(t.getMillis())));
    }

    @Test
    public void testPostProcess() throws Exception {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(new DateTime((Object)new DateTime((Object)"2014-01-09")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(new DateTime((Object)new DateTime((Object)"2014-01-11")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), (Object)new Result(((Interval)query.getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))));
            }
        }, new DateTime((Object)"2014-08-02").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-07-31/2014-08-05").aggregators(Arrays.asList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2014-07-31"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(new DateTime((Object)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3))), new Result(new DateTime((Object)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)5)))}), (Object)Sequences.toList((Sequence)queryRunner.run((Query)query, CONTEXT), (List)Lists.newArrayList()));
        TimewarpOperator timeBoundaryOperator = new TimewarpOperator(new Interval((ReadableInstant)new DateTime((Object)"2014-01-01"), (ReadableInstant)new DateTime((Object)"2014-01-15")), new Period((Object)"P1W"), new DateTime((Object)"2014-01-06"));
        QueryRunner timeBoundaryRunner = timeBoundaryOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeBoundaryResultValue>>(){

            public Sequence<Result<TimeBoundaryResultValue>> run(Query<Result<TimeBoundaryResultValue>> query, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(new DateTime((Object)"2014-01-12"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)new DateTime((Object)"2014-01-12"))))));
            }
        }, new DateTime((Object)"2014-08-02").getMillis());
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("dummy").build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2014-08-02"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)new DateTime((Object)"2014-08-02"))))}), (Object)Sequences.toList((Sequence)timeBoundaryRunner.run((Query)timeBoundaryQuery, CONTEXT), (List)Lists.newArrayList()));
    }

    @Test
    public void testEmptyFutureInterval() throws Exception {
        QueryRunner queryRunner = this.testOperator.postProcess((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)new Result(((Interval)query.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), (Object)new Result(((Interval)query.getIntervals().get(0)).getEnd(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3)))));
            }
        }, new DateTime((Object)"2014-08-02").getMillis());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2014-08-06/2014-08-08").aggregators(Arrays.asList(new CountAggregatorFactory("count"))).build();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Result[]{new Result(new DateTime((Object)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)2))), new Result(new DateTime((Object)"2014-08-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric", (Object)3)))}), (Object)Sequences.toList((Sequence)queryRunner.run((Query)query, (Map)Maps.newHashMap()), (List)Lists.newArrayList()));
    }
}

