/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.RetryQueryRunner;
import io.druid.query.RetryQueryRunnerConfig;
import io.druid.query.SegmentDescriptor;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.SegmentMissingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class RetryQueryRunnerTest {
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    final TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();

    @Test
    public void testRunWithMissingSegments() throws Exception {
        ConcurrentMap context = new MapMaker().makeMap();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query query, Map context) {
                ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(new Interval(178888L, 1999999L), "test", 1));
                return Sequences.empty();
            }
        }, (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new RetryQueryRunnerConfig(){

            public int getNumTries() {
                return 0;
            }

            public boolean isReturnPartialResults() {
                return true;
            }
        }, this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run((Query)this.query, (Map)context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should have one entry in the list of missing segments", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should return an empty sequence as a result", (actualResults.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetry() throws Exception {
        ConcurrentMap context = new MapMaker().makeMap();
        context.put("count", 0);
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> context) {
                if ((Integer)context.get("count") == 0) {
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(new Interval(178888L, 1999999L), "test", 1));
                    context.put("count", 1);
                    return Sequences.empty();
                }
                return Sequences.simple(Arrays.asList(new Result(new DateTime(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
            }
        }, (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new RetryQueryRunnerConfig(){
            private int numTries = 1;
            private boolean returnPartialResults = true;

            public int getNumTries() {
                return this.numTries;
            }

            public boolean returnPartialResults() {
                return this.returnPartialResults;
            }
        }, this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run((Query)this.query, (Map)context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should return a list with one element", (actualResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetryMultiple() throws Exception {
        ConcurrentMap context = new MapMaker().makeMap();
        context.put("count", 0);
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> context) {
                if ((Integer)context.get("count") < 3) {
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(new Interval(178888L, 1999999L), "test", 1));
                    context.put("count", (Integer)context.get("count") + 1);
                    return Sequences.empty();
                }
                return Sequences.simple(Arrays.asList(new Result(new DateTime(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
            }
        }, (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new RetryQueryRunnerConfig(){
            private int numTries = 4;
            private boolean returnPartialResults = true;

            public int getNumTries() {
                return this.numTries;
            }

            public boolean returnPartialResults() {
                return this.returnPartialResults;
            }
        }, this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run((Query)this.query, (Map)context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should return a list with one element", (actualResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=SegmentMissingException.class)
    public void testException() throws Exception {
        ConcurrentMap context = new MapMaker().makeMap();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(Query<Result<TimeseriesResultValue>> query, Map<String, Object> context) {
                ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(new Interval(178888L, 1999999L), "test", 1));
                return Sequences.empty();
            }
        }, (QueryToolChest)new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new RetryQueryRunnerConfig(){
            private int numTries = 1;
            private boolean returnPartialResults = false;

            public int getNumTries() {
                return this.numTries;
            }

            public boolean returnPartialResults() {
                return this.returnPartialResults;
            }
        }, this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run((Query)this.query, (Map)context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should have one entry in the list of missing segments", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 1 ? 1 : 0) != 0);
    }
}

