/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.ImmutableList;
import com.metamx.common.concurrent.ExecutorServiceConfig;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.PrioritizedExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrioritizedExecutorServiceTest {
    private ExecutorService exec;
    private CountDownLatch latch;
    private CountDownLatch finishLatch;

    @Before
    public void setUp() throws Exception {
        this.exec = PrioritizedExecutorService.create((Lifecycle)new Lifecycle(), (ExecutorServiceConfig)new ExecutorServiceConfig(){

            public String getFormatString() {
                return "test";
            }

            public int getNumThreads() {
                return 1;
            }
        });
        this.latch = new CountDownLatch(1);
        this.finishLatch = new CountDownLatch(3);
    }

    @Test
    public void testSubmit() throws Exception {
        final ConcurrentLinkedQueue order = new ConcurrentLinkedQueue();
        this.exec.submit(new AbstractPrioritizedCallable<Void>(0){

            public Void call() throws Exception {
                PrioritizedExecutorServiceTest.this.latch.await();
                return null;
            }
        });
        this.exec.submit(new AbstractPrioritizedCallable<Void>(-1){

            public Void call() throws Exception {
                order.add(-1);
                PrioritizedExecutorServiceTest.this.finishLatch.countDown();
                return null;
            }
        });
        this.exec.submit(new AbstractPrioritizedCallable<Void>(0){

            public Void call() throws Exception {
                order.add(0);
                PrioritizedExecutorServiceTest.this.finishLatch.countDown();
                return null;
            }
        });
        this.exec.submit(new AbstractPrioritizedCallable<Void>(2){

            public Void call() throws Exception {
                order.add(2);
                PrioritizedExecutorServiceTest.this.finishLatch.countDown();
                return null;
            }
        });
        this.latch.countDown();
        this.finishLatch.await();
        Assert.assertTrue((order.size() == 3 ? 1 : 0) != 0);
        ImmutableList expected = ImmutableList.of((Object)2, (Object)0, (Object)-1);
        Assert.assertEquals((Object)expected, (Object)ImmutableList.copyOf(order));
    }
}

