/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryDataSource;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.TableDataSource;
import io.druid.query.UnionDataSource;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testSerialization() throws IOException {
        TableDataSource dataSource = new TableDataSource("somedatasource");
        String json = jsonMapper.writeValueAsString((Object)dataSource);
        DataSource serdeDataSource = (DataSource)jsonMapper.readValue(json, DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serdeDataSource);
    }

    @Test
    public void testLegacyDataSource() throws IOException {
        DataSource dataSource = (DataSource)jsonMapper.readValue("\"somedatasource\"", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testTableDataSource() throws IOException {
        DataSource dataSource = (DataSource)jsonMapper.readValue("{\"type\":\"table\", \"name\":\"somedatasource\"}", DataSource.class);
        Assert.assertEquals((Object)new TableDataSource("somedatasource"), (Object)dataSource);
    }

    @Test
    public void testQueryDataSource() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        String dataSourceJSON = "{\"type\":\"query\", \"query\":" + jsonMapper.writeValueAsString((Object)query) + "}";
        DataSource dataSource = (DataSource)jsonMapper.readValue(dataSourceJSON, DataSource.class);
        Assert.assertEquals((Object)new QueryDataSource((Query)query), (Object)dataSource);
    }

    @Test
    public void testUnionDataSource() throws Exception {
        DataSource dataSource = (DataSource)jsonMapper.readValue("{\"type\":\"union\", \"dataSources\":[\"ds1\", \"ds2\"]}", DataSource.class);
        Assert.assertTrue((boolean)(dataSource instanceof UnionDataSource));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new TableDataSource[]{new TableDataSource("ds1"), new TableDataSource("ds2")}), (Object)Lists.newArrayList((Iterable)((UnionDataSource)dataSource).getDataSources()));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"ds1", "ds2"}), (Object)Lists.newArrayList((Iterable)dataSource.getNames()));
        DataSource serde = (DataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)dataSource), DataSource.class);
        Assert.assertEquals((Object)dataSource, (Object)serde);
    }
}

