/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.druid.guice.ConfigModule;
import io.druid.guice.DruidGuiceExtensions;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.PropertiesModule;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.metadata.MetadataStorageTablesConfig;
import java.util.Arrays;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class MetadataStorageTablesConfigTest {
    @Test
    public void testSerdeMetadataStorageTablesConfig() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new PropertiesModule(Arrays.asList("test.runtime.properties")));
                binder.install((Module)new ConfigModule());
                binder.install((Module)new DruidGuiceExtensions());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.metadata.storage.tables", MetadataStorageTablesConfig.class);
            }

            @Provides
            @LazySingleton
            public ObjectMapper jsonMapper() {
                return new DefaultObjectMapper();
            }
        }});
        Properties props = (Properties)injector.getInstance(Properties.class);
        MetadataStorageTablesConfig config = (MetadataStorageTablesConfig)injector.getInstance(MetadataStorageTablesConfig.class);
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.base"), (Object)config.getBase());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.segments"), (Object)config.getSegmentsTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.rules"), (Object)config.getRulesTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.config"), (Object)config.getConfigTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.tasks"), (Object)config.getEntryTable("task"));
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.taskLog"), (Object)config.getLogTable("task"));
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.taskLock"), (Object)config.getLockTable("task"));
    }
}

