/*
 * Decompiled with CFR 0.152.
 */
package io.druid.granularity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.granularity.DurationGranularity;
import io.druid.granularity.PeriodGranularity;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.junit.Assert;
import org.junit.Test;

public class QueryGranularityTest {
    @Test
    public void testIterableNone() throws Exception {
        ArrayList millis = Lists.newArrayList((Iterable)QueryGranularity.NONE.iterable(0L, 1000L));
        int count = 0;
        Assert.assertEquals((long)1000L, (long)millis.size());
        for (Long milli : millis) {
            Assert.assertEquals((long)count, (long)milli);
            ++count;
        }
    }

    @Test
    public void testIterableMinuteSimple() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:38:00.000Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T09:38:00.000Z"), new DateTime((Object)"2011-01-01T09:39:00.000Z"), new DateTime((Object)"2011-01-01T09:40:00.000Z")}), QueryGranularity.MINUTE.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Minutes.THREE).getMillis()));
    }

    @Test
    public void testIterableMinuteComplex() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:38:02.992Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T09:38:00.000Z"), new DateTime((Object)"2011-01-01T09:39:00.000Z"), new DateTime((Object)"2011-01-01T09:40:00.000Z"), new DateTime((Object)"2011-01-01T09:41:00.000Z")}), QueryGranularity.MINUTE.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Minutes.THREE).getMillis()));
    }

    @Test
    public void testIterable15MinuteSimple() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:30:00.000Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T09:30:00.000Z"), new DateTime((Object)"2011-01-01T09:45:00.000Z"), new DateTime((Object)"2011-01-01T10:00:00.000Z")}), QueryGranularity.fromString((String)"FIFTEEN_MINUTE").iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Minutes.minutes((int)45)).getMillis()));
    }

    @Test
    public void testIterable15MinuteComplex() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:38:02.992Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T09:30:00.000Z"), new DateTime((Object)"2011-01-01T09:45:00.000Z"), new DateTime((Object)"2011-01-01T10:00:00.000Z"), new DateTime((Object)"2011-01-01T10:15:00.000Z")}), QueryGranularity.fromString((String)"FIFTEEN_MINUTE").iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Minutes.minutes((int)45)).getMillis()));
    }

    @Test
    public void testIterableHourSimple() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:00:00.000Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T09:00:00.000Z"), new DateTime((Object)"2011-01-01T10:00:00.000Z"), new DateTime((Object)"2011-01-01T11:00:00.000Z")}), QueryGranularity.HOUR.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Hours.hours((int)3)).getMillis()));
    }

    @Test
    public void testIterableHourComplex() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:38:02.992Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T09:00:00.000Z"), new DateTime((Object)"2011-01-01T10:00:00.000Z"), new DateTime((Object)"2011-01-01T11:00:00.000Z"), new DateTime((Object)"2011-01-01T12:00:00.000Z")}), QueryGranularity.HOUR.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Hours.hours((int)3)).getMillis()));
    }

    @Test
    public void testIterableDaySimple() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T00:00:00.000Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T00:00:00.000Z"), new DateTime((Object)"2011-01-02T00:00:00.000Z"), new DateTime((Object)"2011-01-03T00:00:00.000Z")}), QueryGranularity.DAY.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Days.days((int)3)).getMillis()));
    }

    @Test
    public void testIterableDayComplex() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:38:02.992Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-01-01T00:00:00.000Z"), new DateTime((Object)"2011-01-02T00:00:00.000Z"), new DateTime((Object)"2011-01-03T00:00:00.000Z"), new DateTime((Object)"2011-01-04T00:00:00.000Z")}), QueryGranularity.DAY.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Days.days((int)3)).getMillis()));
    }

    @Test
    public void testPeriodDaylightSaving() throws Exception {
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime baseTime = new DateTime((Object)"2012-11-04T00:00:00", tz);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-04T00:00:00.000-07:00"), new DateTime((Object)"2012-11-05T00:00:00.000-08:00"), new DateTime((Object)"2012-11-06T00:00:00.000-08:00")}), new PeriodGranularity(new Period((Object)"P1D"), null, tz).iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Days.days((int)3)).getMillis()));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-04T00:00:00.000-07:00"), new DateTime((Object)"2012-11-04T01:00:00.000-07:00"), new DateTime((Object)"2012-11-04T01:00:00.000-08:00"), new DateTime((Object)"2012-11-04T02:00:00.000-08:00"), new DateTime((Object)"2012-11-04T03:00:00.000-08:00")}), new PeriodGranularity(new Period((Object)"PT1H"), null, tz).iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Hours.hours((int)5)).getMillis()));
        PeriodGranularity hour = new PeriodGranularity(new Period((Object)"PT1H"), null, tz);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-04T00:00:00.000-07:00"), new DateTime((Object)"2012-11-04T01:00:00.000-07:00"), new DateTime((Object)"2012-11-04T01:00:00.000-08:00"), new DateTime((Object)"2012-11-04T02:00:00.000-08:00"), new DateTime((Object)"2012-11-04T03:00:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{hour.truncate(new DateTime((Object)"2012-11-04T00:30:00-07:00").getMillis()), hour.truncate(new DateTime((Object)"2012-11-04T01:30:00-07:00").getMillis()), hour.truncate(new DateTime((Object)"2012-11-04T01:30:00-08:00").getMillis()), hour.truncate(new DateTime((Object)"2012-11-04T02:30:00-08:00").getMillis()), hour.truncate(new DateTime((Object)"2012-11-04T03:30:00-08:00").getMillis())}));
    }

    @Test
    public void testIterableMonth() throws Exception {
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime baseTime = new DateTime((Object)"2012-11-03T10:00:00", tz);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-01T00:00:00.000-07:00"), new DateTime((Object)"2012-12-01T00:00:00.000-08:00"), new DateTime((Object)"2013-01-01T00:00:00.000-08:00"), new DateTime((Object)"2013-02-01T00:00:00.000-08:00")}), new PeriodGranularity(new Period((Object)"P1M"), null, tz).iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Months.months((int)3)).getMillis()));
    }

    @Test
    public void testIterableWeek() throws Exception {
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime baseTime = new DateTime((Object)"2012-11-03T10:00:00", tz);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-10-29T00:00:00.000-07:00"), new DateTime((Object)"2012-11-05T00:00:00.000-08:00"), new DateTime((Object)"2012-11-12T00:00:00.000-08:00"), new DateTime((Object)"2012-11-19T00:00:00.000-08:00")}), new PeriodGranularity(new Period((Object)"P1W"), null, tz).iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Weeks.weeks((int)3)).getMillis()));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-11-03T10:00:00.000-07:00"), new DateTime((Object)"2012-11-10T10:00:00.000-08:00"), new DateTime((Object)"2012-11-17T10:00:00.000-08:00")}), new PeriodGranularity(new Period((Object)"P1W"), baseTime, tz).iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Weeks.weeks((int)3)).getMillis()));
    }

    @Test
    public void testPeriodTruncateDays() throws Exception {
        DateTime origin = new DateTime((Object)"2012-01-02T05:00:00.000-08:00");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"P2D"), origin, DateTimeZone.forID((String)"America/Los_Angeles"));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-12-31T05:00:00.000-08:00"), new DateTime((Object)"2012-01-02T05:00:00.000-08:00"), new DateTime((Object)"2012-01-04T05:00:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{periodOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-02T07:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-04T07:20:04.123-08:00").getMillis())}));
        PeriodGranularity periodNoOrigin = new PeriodGranularity(new Period((Object)"P2D"), null, DateTimeZone.forID((String)"America/Los_Angeles"));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T00:00:00.000-08:00"), new DateTime((Object)"2012-01-01T00:00:00.000-08:00"), new DateTime((Object)"2012-01-03T00:00:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{periodNoOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123-08:00").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-01-02T07:00:04.123-08:00").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-01-04T07:20:04.123-08:00").getMillis())}));
    }

    @Test
    public void testPeriodTruncateMinutes() throws Exception {
        DateTime origin = new DateTime((Object)"2012-01-02T00:05:00.000Z");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"PT15M"), origin, null);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T04:50:00.000Z"), new DateTime((Object)"2012-01-02T07:05:00.000Z"), new DateTime((Object)"2012-01-04T00:20:00.000Z")}), Lists.newArrayList((Object[])new Long[]{periodOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123Z").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-02T07:08:04.123Z").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-04T00:20:04.123Z").getMillis())}));
        PeriodGranularity periodNoOrigin = new PeriodGranularity(new Period((Object)"PT15M"), null, null);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T05:00:00.000Z"), new DateTime((Object)"2012-01-02T07:00:00.000Z"), new DateTime((Object)"2012-01-04T00:15:00.000Z")}), Lists.newArrayList((Object[])new Long[]{periodNoOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123Z").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-01-02T07:00:04.123Z").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-01-04T00:20:04.123Z").getMillis())}));
    }

    @Test
    public void testCompoundPeriodTruncate() throws Exception {
        DateTime origin = new DateTime((Object)"2012-01-02T05:00:00.000-08:00");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"P1M2D"), origin, DateTimeZone.forID((String)"America/Los_Angeles"));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2011-11-30T05:00:00.000-08:00"), new DateTime((Object)"2012-01-02T05:00:00.000-08:00"), new DateTime((Object)"2012-02-04T05:00:00.000-08:00"), new DateTime((Object)"2012-02-04T05:00:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{periodOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-02T07:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-03-01T07:20:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-02-04T05:00:00.000-08:00").getMillis())}));
        PeriodGranularity periodNoOrigin = new PeriodGranularity(new Period((Object)"P1M2D"), null, DateTimeZone.forID((String)"America/Los_Angeles"));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"1970-01-01T00:00:00.000-08:00"), new DateTime((Object)"2011-12-12T00:00:00.000-08:00"), new DateTime((Object)"2012-01-14T00:00:00.000-08:00"), new DateTime((Object)"2012-02-16T00:00:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{periodNoOrigin.truncate(new DateTime((Object)"1970-01-01T05:02:04.123-08:00").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-01-01T05:02:04.123-08:00").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-01-15T07:01:04.123-08:00").getMillis()), periodNoOrigin.truncate(new DateTime((Object)"2012-02-16T00:00:00.000-08:00").getMillis())}));
        origin = new DateTime((Object)"2012-01-02T05:00:00.000-08:00");
        periodOrigin = new PeriodGranularity(new Period((Object)"PT12H5M"), origin, DateTimeZone.forID((String)"America/Los_Angeles"));
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T04:50:00.000-08:00"), new DateTime((Object)"2012-01-02T05:00:00.000-08:00"), new DateTime((Object)"2012-01-02T17:05:00.000-08:00"), new DateTime((Object)"2012-02-03T22:25:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{periodOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-02T07:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-03T00:20:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-02-03T22:25:00.000-08:00").getMillis())}));
    }

    @Test
    public void testCompoundPeriodMillisTruncate() throws Exception {
        DateTime origin = new DateTime((Object)"2012-01-02T05:00:00.000-08:00");
        PeriodGranularity periodOrigin = new PeriodGranularity(new Period((Object)"PT12H5M"), origin, DateTimeZone.UTC);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T04:50:00.000-08:00"), new DateTime((Object)"2012-01-02T05:00:00.000-08:00"), new DateTime((Object)"2012-01-02T17:05:00.000-08:00"), new DateTime((Object)"2012-02-03T22:25:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{periodOrigin.truncate(new DateTime((Object)"2012-01-01T05:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-02T07:00:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-01-03T00:20:04.123-08:00").getMillis()), periodOrigin.truncate(new DateTime((Object)"2012-02-03T22:25:00.000-08:00").getMillis())}));
    }

    @Test
    public void testDurationTruncate() throws Exception {
        DateTime origin = new DateTime((Object)"2012-01-02T05:00:00.000-08:00");
        DurationGranularity gran = new DurationGranularity(new Period((Object)"PT12H5M").toStandardDuration().getMillis(), origin);
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{new DateTime((Object)"2012-01-01T04:50:00.000-08:00"), new DateTime((Object)"2012-01-02T05:00:00.000-08:00"), new DateTime((Object)"2012-01-02T17:05:00.000-08:00"), new DateTime((Object)"2012-02-03T22:25:00.000-08:00")}), Lists.newArrayList((Object[])new Long[]{gran.truncate(new DateTime((Object)"2012-01-01T05:00:04.123-08:00").getMillis()), gran.truncate(new DateTime((Object)"2012-01-02T07:00:04.123-08:00").getMillis()), gran.truncate(new DateTime((Object)"2012-01-03T00:20:04.123-08:00").getMillis()), gran.truncate(new DateTime((Object)"2012-02-03T22:25:00.000-08:00").getMillis())}));
    }

    @Test
    public void testIterableAllSimple() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T00:00:00.000Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{baseTime}), QueryGranularity.ALL.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Days.days((int)3)).getMillis()));
    }

    @Test
    public void testIterableAllComplex() throws Exception {
        DateTime baseTime = new DateTime((Object)"2011-01-01T09:38:02.992Z");
        this.assertSame(Lists.newArrayList((Object[])new DateTime[]{baseTime}), QueryGranularity.ALL.iterable(baseTime.getMillis(), baseTime.plus((ReadablePeriod)Days.days((int)3)).getMillis()));
    }

    @Test
    public void testSerializePeriod() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String json = "{ \"type\": \"period\", \"period\": \"P1D\" }";
        QueryGranularity gran = (QueryGranularity)mapper.readValue(json, QueryGranularity.class);
        Assert.assertEquals((Object)new PeriodGranularity(new Period((Object)"P1D"), null, null), (Object)gran);
        json = "{ \"type\": \"period\", \"period\": \"P1D\",\"timeZone\": \"America/Los_Angeles\", \"origin\": \"1970-01-01T00:00:00Z\"}";
        gran = (QueryGranularity)mapper.readValue(json, QueryGranularity.class);
        Assert.assertEquals((Object)new PeriodGranularity(new Period((Object)"P1D"), new DateTime(0L), DateTimeZone.forID((String)"America/Los_Angeles")), (Object)gran);
        PeriodGranularity expected = new PeriodGranularity(new Period((Object)"P1D"), new DateTime((Object)"2012-01-01"), DateTimeZone.forID((String)"America/Los_Angeles"));
        String jsonOut = mapper.writeValueAsString((Object)expected);
        Assert.assertEquals((Object)expected, (Object)mapper.readValue(jsonOut, QueryGranularity.class));
    }

    @Test
    public void testSerializeDuration() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String json = "{ \"type\": \"duration\", \"duration\": \"3600000\" }";
        QueryGranularity gran = (QueryGranularity)mapper.readValue(json, QueryGranularity.class);
        Assert.assertEquals((Object)new DurationGranularity(3600000L, null), (Object)gran);
        json = "{ \"type\": \"duration\", \"duration\": \"5\", \"origin\": \"2012-09-01T00:00:00.002Z\" }";
        gran = (QueryGranularity)mapper.readValue(json, QueryGranularity.class);
        Assert.assertEquals((Object)new DurationGranularity(5L, 2L), (Object)gran);
        DurationGranularity expected = new DurationGranularity(5L, 2L);
        Assert.assertEquals((Object)expected, (Object)mapper.readValue(mapper.writeValueAsString((Object)expected), QueryGranularity.class));
    }

    @Test
    public void testSerializeSimple() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)QueryGranularity.ALL, (Object)mapper.readValue(mapper.writeValueAsString((Object)QueryGranularity.ALL), QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.NONE, (Object)mapper.readValue(mapper.writeValueAsString((Object)QueryGranularity.NONE), QueryGranularity.class));
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)QueryGranularity.ALL, (Object)mapper.readValue("\"all\"", QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.ALL, (Object)mapper.readValue("\"ALL\"", QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.NONE, (Object)mapper.readValue("\"none\"", QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.NONE, (Object)mapper.readValue("\"NONE\"", QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.DAY, (Object)mapper.readValue("\"day\"", QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.HOUR, (Object)mapper.readValue("\"hour\"", QueryGranularity.class));
        Assert.assertEquals((Object)QueryGranularity.MINUTE, (Object)mapper.readValue("\"minute\"", QueryGranularity.class));
        QueryGranularity gran = (QueryGranularity)mapper.readValue("\"thirty_minute\"", QueryGranularity.class);
        Assert.assertEquals((Object)new DurationGranularity(1800000L, null), (Object)gran);
        gran = (QueryGranularity)mapper.readValue("\"fifteen_minute\"", QueryGranularity.class);
        Assert.assertEquals((Object)new DurationGranularity(900000L, null), (Object)gran);
    }

    private void assertSame(List<DateTime> expected, Iterable<Long> actual) {
        Assert.assertEquals((long)expected.size(), (long)Iterables.size(actual));
        Iterator<Long> actualIter = actual.iterator();
        Iterator<DateTime> expectedIter = expected.iterator();
        while (actualIter.hasNext() && expectedIter.hasNext()) {
            long a = actualIter.next();
            Assert.assertEquals((Object)expectedIter.next(), (Object)new DateTime(a));
        }
        Assert.assertFalse((String)"actualIter not exhausted!?", (boolean)actualIter.hasNext());
        Assert.assertFalse((String)"expectedIter not exhausted!?", (boolean)expectedIter.hasNext());
    }
}

