/*
 * Druid - a distributed column store.
 * Copyright 2012 - 2015 Metamarkets Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.druid.query.filter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.List;

/**
 */
public class DimFilters
{
  public static SelectorDimFilter dimEquals(String dimension, String value)
  {
    return new SelectorDimFilter(dimension, value);
  }

  public static AndDimFilter and(DimFilter... filters)
  {
    return and(Arrays.asList(filters));
  }

  public static AndDimFilter and(List<DimFilter> filters)
  {
    return new AndDimFilter(filters);
  }

  public static OrDimFilter or(DimFilter... filters)
  {
    return or(Arrays.asList(filters));
  }

  public static OrDimFilter or(List<DimFilter> filters)
  {
    return new OrDimFilter(filters);
  }

  public static NotDimFilter not(DimFilter filter)
  {
    return new NotDimFilter(filter);
  }

  public static RegexDimFilter regex(String dimension, String pattern)
  {
    return new RegexDimFilter(dimension, pattern);
  }

  public static DimFilter dimEquals(final String dimension, String... values)
  {
    return or(
        Lists.transform(
            Arrays.asList(values),
            new Function<String, DimFilter>()
            {
              @Override
              public DimFilter apply(String input)
              {
                return dimEquals(dimension, input);
              }
            }
        )
    );
  }
}
