/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.LongGenericColumnSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class LongGenericColumnPartSerde
implements ColumnPartSerde {
    private final CompressedLongsIndexedSupplier compressedLongs;
    private final ByteOrder byteOrder;

    @JsonCreator
    public static LongGenericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new LongGenericColumnPartSerde(null, byteOrder);
    }

    public LongGenericColumnPartSerde(CompressedLongsIndexedSupplier compressedLongs, ByteOrder byteOrder) {
        this.compressedLongs = compressedLongs;
        this.byteOrder = byteOrder;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public long numBytes() {
        return this.compressedLongs.getSerializedSize();
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        this.compressedLongs.writeToChannel(channel);
    }

    @Override
    public ColumnPartSerde read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        CompressedLongsIndexedSupplier column = CompressedLongsIndexedSupplier.fromByteBuffer(buffer, this.byteOrder);
        builder.setType(ValueType.LONG).setHasMultipleValues(false).setGenericColumn(new LongGenericColumnSupplier(column));
        return new LongGenericColumnPartSerde(column, this.byteOrder);
    }
}

