/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import io.druid.data.input.InputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;

public class OnheapIncrementalIndex
extends IncrementalIndex<Aggregator> {
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final ConcurrentNavigableMap<IncrementalIndex.TimeAndDims, Integer> facts = new ConcurrentSkipListMap<IncrementalIndex.TimeAndDims, Integer>();
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    private String outOfRowsReason = null;

    public OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, int maxRowCount) {
        super(incrementalIndexSchema, deserializeComplexMetrics);
        this.maxRowCount = maxRowCount;
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, boolean deserializeComplexMetrics, int maxRowCount) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build(), deserializeComplexMetrics, maxRowCount);
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, int maxRowCount) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build(), true, maxRowCount);
    }

    public OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, int maxRowCount) {
        this(incrementalIndexSchema, true, maxRowCount);
    }

    @Override
    public ConcurrentNavigableMap<IncrementalIndex.TimeAndDims, Integer> getFacts() {
        return this.facts;
    }

    @Override
    protected IncrementalIndex.DimDim makeDimDim(String dimension) {
        return new OnHeapDimDim();
    }

    protected Aggregator[] initAggs(AggregatorFactory[] metrics, ThreadLocal<InputRow> in, boolean deserializeComplexMetrics) {
        return new Aggregator[metrics.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> in) throws IndexSizeExceededException {
        Aggregator[] aggs;
        Integer priorIndex = (Integer)this.facts.get(key);
        if (null != priorIndex) {
            aggs = this.concurrentGet(priorIndex);
        } else {
            aggs = new Aggregator[metrics.length];
            for (int i = 0; i < metrics.length; ++i) {
                AggregatorFactory agg = metrics[i];
                aggs[i] = agg.factorize(OnheapIncrementalIndex.makeColumnSelectorFactory(agg, in, deserializeComplexMetrics));
            }
            Integer rowIndex = this.indexIncrement.getAndIncrement();
            this.concurrentSet(rowIndex, aggs);
            if (numEntries.get() >= this.maxRowCount && !this.facts.containsKey(key)) {
                throw new IndexSizeExceededException("Maximum number of rows reached");
            }
            Integer prev = this.facts.putIfAbsent(key, rowIndex);
            if (null == prev) {
                numEntries.incrementAndGet();
            } else {
                aggs = this.concurrentGet(prev);
                this.concurrentRemove(rowIndex);
            }
        }
        in.set(row);
        Aggregator[] arr$ = aggs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Aggregator agg;
            Aggregator aggregator = agg = arr$[i$];
            synchronized (aggregator) {
                agg.aggregate();
                continue;
            }
        }
        in.set(null);
        return numEntries.get();
    }

    protected Aggregator[] concurrentGet(int offset) {
        return this.aggregators.get(offset);
    }

    protected void concurrentSet(int offset, Aggregator[] value) {
        this.aggregators.put(offset, value);
    }

    protected void concurrentRemove(int offset) {
        this.aggregators.remove(offset);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean bl = canAdd = this.size() < this.maxRowCount;
        if (!canAdd) {
            this.outOfRowsReason = String.format("Maximum number of rows [%d] reached", this.maxRowCount);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected Aggregator[] getAggsForRow(int rowOffset) {
        return this.concurrentGet(rowOffset);
    }

    @Override
    protected Object getAggVal(Aggregator agg, int rowOffset, int aggPosition) {
        return agg.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getLong();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].get();
    }

    private static class OnHeapDimDim
    implements IncrementalIndex.DimDim {
        private final Map<String, Integer> falseIds;
        private final Map<Integer, String> falseIdsReverse;
        private volatile String[] sortedVals = null;
        final ConcurrentMap<String, String> poorMansInterning = Maps.newConcurrentMap();

        public OnHeapDimDim() {
            BiMap biMap;
            this.falseIds = biMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
            this.falseIdsReverse = biMap.inverse();
        }

        @Override
        public String get(String str) {
            String prev = this.poorMansInterning.putIfAbsent(str, str);
            return prev != null ? prev : str;
        }

        @Override
        public int getId(String value) {
            Integer id = this.falseIds.get(value);
            return id == null ? -1 : id;
        }

        @Override
        public String getValue(int id) {
            return this.falseIdsReverse.get(id);
        }

        @Override
        public boolean contains(String value) {
            return this.falseIds.containsKey(value);
        }

        @Override
        public int size() {
            return this.falseIds.size();
        }

        @Override
        public synchronized int add(String value) {
            int id = this.falseIds.size();
            this.falseIds.put(value, id);
            return id;
        }

        @Override
        public int getSortedId(String value) {
            this.assertSorted();
            return Arrays.binarySearch(this.sortedVals, value);
        }

        @Override
        public String getSortedValue(int index) {
            this.assertSorted();
            return this.sortedVals[index];
        }

        @Override
        public void sort() {
            if (this.sortedVals == null) {
                this.sortedVals = new String[this.falseIds.size()];
                int index = 0;
                for (String value : this.falseIds.keySet()) {
                    this.sortedVals[index++] = value;
                }
                Arrays.sort(this.sortedVals);
            }
        }

        private void assertSorted() {
            if (this.sortedVals == null) {
                throw new ISE("Call sort() before calling the getSorted* methods.", new Object[0]);
            }
        }

        @Override
        public boolean compareCannonicalValues(String s1, String s2) {
            return s1 == s2;
        }
    }
}

