/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Strings;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.BooleanValueMatcher;

public class SelectorFilter
implements Filter {
    private final String dimension;
    private final String value;

    public SelectorFilter(String dimension, String value) {
        this.dimension = dimension;
        this.value = value;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension, this.value);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.value);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory columnSelectorFactory) {
        final DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector(this.dimension, null);
        if (dimensionSelector == null) {
            return new BooleanValueMatcher(Strings.isNullOrEmpty((String)this.value));
        }
        final int valueId = dimensionSelector.lookupId(this.value);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts row = dimensionSelector.getRow();
                int size = row.size();
                for (int i = 0; i < size; ++i) {
                    if (row.get(i) != valueId) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

